/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise.rna;

import edu.msu.cme.rdp.alignment.pairwise.rna.DistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.OverlapCheckFailedException;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;

public class IdentityDistanceModel
extends DistanceModel {
    private static final byte DASH = 45;
    private static final byte DOT = 46;
    private boolean metric = false;

    public IdentityDistanceModel() {
    }

    public IdentityDistanceModel(boolean metric) {
        this.metric = metric;
    }

    public double getDistance(byte[] seqX, byte[] seqY, int overlapMin) throws OverlapCheckFailedException {
        int match = 0;
        int compPositions = 0;
        for (int index = 0; index < seqX.length; ++index) {
            if (!this.metric && (seqX[index] == 45 || seqX[index] == SeqUtils.GAP || seqX[index] == 46 || seqY[index] == 45 || seqY[index] == SeqUtils.GAP || seqY[index] == 46)) continue;
            ++compPositions;
            if (seqX[index] != seqY[index]) continue;
            ++match;
        }
        if (compPositions < overlapMin) {
            throw new OverlapCheckFailedException("");
        }
        return 1.0f - (float)match / (float)compPositions;
    }

    public static void main(String[] args) throws Exception {
        String s1 = "--------KIAVYENETPLFVSNIKHSVEELSAFPEVIDQFEFRKNLVLQELENNKIPF-SFDAIIGRGGLVKPIPGGVYEVNEAMKRDTVHAMR-THACNLGGLIASELASTLPCPAFIADPGVVDELEDIARITGSPLMPKIT--------------------";
        String s2 = "---------IAVYENETPLFVSNIKHSVEELSAFPEVIDQFEFRKNLVLQELENNKIPF-SFDAIIGRGGLVKPIPGGVYEVNEAMKRDTVHAMR-THACNLGGLIASELASTLPCPAFIADPGVVDELEDIARITGSPLMPKITI-------------------";
        System.out.println(new IdentityDistanceModel().getDistance(s1.getBytes(), s2.getBytes(), 0));
        System.out.println(new IdentityDistanceModel(true).getDistance(s1.getBytes(), s2.getBytes(), 0));
    }
}

