/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.scenegraph.ChildManager;
import org.biojava.utils.scenegraph.Component;

class ListChildManager
implements ChildManager {
    Component managee;
    private List children = null;

    public int countChildren() {
        return this.getChildren().size();
    }

    public Iterator childIterator() {
        return this.getChildren().iterator();
    }

    public ListChildManager(Component component) {
        this.managee = component;
        this.children = new ArrayList();
    }

    public List getChildren() {
        return this.children;
    }

    public boolean insert(int n, Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        List list = this.getChildren();
        if (n == -1000000 || n >= list.size()) {
            list.add(component);
        } else if (n == -2000000 || n < 0) {
            list.add(0, component);
        } else {
            list.add(n, component);
        }
        component.setParent(this.managee);
        return true;
    }

    public boolean remove(Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        if (!this.getChildren().remove(component)) {
            return false;
        }
        component.setParent(null);
        return true;
    }

    public boolean replace(Component component, Component component2) {
        if (component == null) {
            throw new NullPointerException("oldChild was null");
        }
        if (component2 == null) {
            throw new NullPointerException("newChild was null");
        }
        List list = this.getChildren();
        int n = list.indexOf(component);
        if (n == -1) {
            return false;
        }
        list.set(n, component2);
        component.setParent(null);
        component2.setParent(this.managee);
        return true;
    }

    public boolean raise(Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        List list = this.getChildren();
        int n = list.indexOf(component);
        if (n == list.size() - 1) {
            return false;
        }
        list.set(n, list.get(n + 1));
        list.set(n + 1, component);
        return true;
    }

    public boolean lower(Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        List list = this.getChildren();
        int n = list.indexOf(component);
        if (n == 0) {
            return false;
        }
        list.set(n, list.get(n - 1));
        list.set(n - 1, component);
        return true;
    }

    public boolean toTop(Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        List list = this.getChildren();
        if (!list.contains(component)) {
            return false;
        }
        list.remove(component);
        list.add(component);
        return true;
    }

    public boolean toBottom(Component component) {
        if (component == null) {
            throw new NullPointerException("child was null");
        }
        List list = this.getChildren();
        if (!list.contains(component)) {
            return false;
        }
        list.remove(component);
        list.add(0, component);
        return true;
    }
}

