/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.IntrospectedCodeConstructor;
import org.biojava.utils.bytecode.IntrospectedCodeMethod;

public class IntrospectedCodeClass
implements CodeClass {
    private static Map introspectedClasses = new HashMap();
    private static Map primitiveDescriptors = new HashMap();
    private Class clazz;
    private Set _methods;

    public static CodeClass forClass(Class clazz) {
        CodeClass codeClass = (CodeClass)introspectedClasses.get(clazz);
        if (codeClass == null) {
            codeClass = new IntrospectedCodeClass(clazz);
            introspectedClasses.put(clazz, codeClass);
        }
        return codeClass;
    }

    public static CodeClass forClass(String string) throws ClassNotFoundException {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
        return IntrospectedCodeClass.forClass(clazz);
    }

    private IntrospectedCodeClass(Class clazz) {
        this.clazz = clazz;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getJName() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append('/');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getDescriptor() {
        if (this.clazz.isPrimitive()) {
            String string = (String)primitiveDescriptors.get(this.clazz);
            if (string == null) {
                throw new RuntimeException("Unknown primitive type " + this.clazz.getName() + ", eeek!");
            }
            return string;
        }
        if (this.clazz.isArray()) {
            return "[" + IntrospectedCodeClass.forClass(this.clazz.getComponentType()).getDescriptor();
        }
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append('/');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public CodeClass getSuperClass() {
        return IntrospectedCodeClass.forClass(this.clazz.getSuperclass());
    }

    public List getInterfaces() {
        Class<?>[] classArray = this.clazz.getInterfaces();
        return Arrays.asList(classArray);
    }

    public Set getMethods() {
        if (this._methods == null) {
            Method[] methodArray = this.clazz.getMethods();
            this._methods = new HashSet();
            int n = 0;
            while (n < methodArray.length) {
                this._methods.add(new IntrospectedCodeMethod(methodArray[n]));
                ++n;
            }
        }
        return this._methods;
    }

    public CodeField getFieldByName(String string) throws NoSuchFieldException {
        try {
            Field field = this.clazz.getField(string);
            return new CodeField(this, string, IntrospectedCodeClass.forClass(field.getType()), field.getModifiers());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldException("Can't find field " + string + " in class " + this.getName());
        }
    }

    public Set getMethodsByName(String string) {
        HashSet<CodeMethod> hashSet = new HashSet<CodeMethod>();
        Iterator iterator = this.getMethods().iterator();
        while (iterator.hasNext()) {
            CodeMethod codeMethod = (CodeMethod)iterator.next();
            if (!codeMethod.getName().equals(string)) continue;
            hashSet.add(codeMethod);
        }
        return hashSet;
    }

    public CodeMethod getMethod(String string, CodeClass[] codeClassArray) throws NoSuchMethodException {
        try {
            Class[] classArray = new Class[codeClassArray.length];
            int n = 0;
            while (n < codeClassArray.length) {
                classArray[n] = ((IntrospectedCodeClass)codeClassArray[n]).clazz;
                ++n;
            }
            return new IntrospectedCodeMethod(this.clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodException("Could not find method " + this.getName() + "." + string + "(" + CodeUtils.classListToString(codeClassArray) + ")");
        }
    }

    public CodeMethod getConstructor(CodeClass[] codeClassArray) throws NoSuchMethodException {
        try {
            Class[] classArray = new Class[codeClassArray.length];
            int n = 0;
            while (n < codeClassArray.length) {
                classArray[n] = ((IntrospectedCodeClass)codeClassArray[n]).clazz;
                ++n;
            }
            return new IntrospectedCodeConstructor(this.clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodException("Could not find constructor new " + this.getName() + "(" + CodeUtils.classListToString(codeClassArray) + ")");
        }
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    static {
        primitiveDescriptors.put(Byte.TYPE, "B");
        primitiveDescriptors.put(Character.TYPE, "C");
        primitiveDescriptors.put(Double.TYPE, "D");
        primitiveDescriptors.put(Float.TYPE, "F");
        primitiveDescriptors.put(Integer.TYPE, "I");
        primitiveDescriptors.put(Long.TYPE, "J");
        primitiveDescriptors.put(Short.TYPE, "S");
        primitiveDescriptors.put(Boolean.TYPE, "Z");
        primitiveDescriptors.put(Void.TYPE, "V");
    }
}

