/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;

public class ConstantPool {
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private List constants = new ArrayList();

    public ConstantPool() {
        this.constants.add(null);
    }

    public int resolveClass(CodeClass codeClass) {
        return this.resolve(new CPTypedStringEntry(7, this.resolveUtf8(codeClass.getJName())));
    }

    public int resolveField(CodeField codeField) {
        try {
            return this.resolve(new CPRefEntry(9, this.resolveClass(codeField.getContainingClass()), this.resolveNameAndType(codeField.getName(), codeField.getType().getDescriptor())));
        }
        catch (NullPointerException nullPointerException) {
            throw new Error("Can't resolve filed " + codeField);
        }
    }

    public int resolveMethod(CodeMethod codeMethod) {
        return this.resolve(new CPRefEntry(10, this.resolveClass(codeMethod.getContainingClass()), this.resolveNameAndType(codeMethod.getName(), codeMethod.getDescriptor())));
    }

    public int resolveInterfaceMethod(CodeMethod codeMethod) {
        return this.resolve(new CPRefEntry(11, this.resolveClass(codeMethod.getContainingClass()), this.resolveNameAndType(codeMethod.getName(), codeMethod.getDescriptor())));
    }

    public int resolveString(String string) {
        return this.resolve(new CPTypedStringEntry(8, this.resolveUtf8(string)));
    }

    public int resolveInt(int n) {
        return this.resolve(new CPIntEntry(n));
    }

    public int resolveFloat(float f) {
        return this.resolve(new CPFloatEntry(f));
    }

    public int resolveLong(long l) {
        return this.resolve(new CPLongEntry(l));
    }

    public int resolveDouble(double d) {
        return this.resolve(new CPDoubleEntry(d));
    }

    public int resolveUtf8(String string) {
        return this.resolve(new CPUtf8Entry(string));
    }

    public int resolveNameAndType(String string, String string2) {
        return this.resolve(new CPNameAndTypeEntry(this.resolveUtf8(string), this.resolveUtf8(string2)));
    }

    private int resolve(CPEntry cPEntry) {
        int n = 1;
        while (n < this.constants.size()) {
            CPEntry cPEntry2 = (CPEntry)this.constants.get(n);
            if (cPEntry2 != null && cPEntry.equals(cPEntry2)) {
                return n;
            }
            ++n;
        }
        int n2 = this.constants.size();
        this.constants.add(cPEntry);
        int n3 = 1;
        while (n3 < cPEntry.needSlots()) {
            this.constants.add(null);
            ++n3;
        }
        return n2;
    }

    public int constantPoolSize() {
        return this.constants.size();
    }

    public void writeConstantPool(DataOutput dataOutput) throws IOException {
        Iterator iterator = this.constants.iterator();
        while (iterator.hasNext()) {
            CPEntry cPEntry = (CPEntry)iterator.next();
            if (cPEntry == null) continue;
            cPEntry.write(dataOutput);
        }
    }

    private static class CPNameAndTypeEntry
    implements CPEntry {
        int name;
        int desc;

        CPNameAndTypeEntry(int n, int n2) {
            this.name = n;
            this.desc = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPNameAndTypeEntry)) {
                return false;
            }
            CPNameAndTypeEntry cPNameAndTypeEntry = (CPNameAndTypeEntry)object;
            return cPNameAndTypeEntry.desc == this.desc && cPNameAndTypeEntry.name == this.name;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(12);
            dataOutput.writeShort(this.name);
            dataOutput.writeShort(this.desc);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPNameAndTypeEntry name=" + this.name + " desc=" + this.desc;
        }
    }

    private static class CPUtf8Entry
    implements CPEntry {
        String val;

        CPUtf8Entry(String string) {
            this.val = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPUtf8Entry)) {
                return false;
            }
            return ((CPUtf8Entry)object).val.equals(this.val);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(1);
            dataOutput.writeUTF(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPUtf8Entry val=" + this.val;
        }
    }

    private static class CPDoubleEntry
    implements CPEntry {
        double val;

        CPDoubleEntry(double d) {
            this.val = d;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPDoubleEntry)) {
                return false;
            }
            return ((CPDoubleEntry)object).val == this.val || Double.isNaN(((CPDoubleEntry)object).val) && Double.isNaN(this.val);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(6);
            dataOutput.writeDouble(this.val);
        }

        public int needSlots() {
            return 2;
        }

        public String toString() {
            return "CPDoubleEntry val=" + this.val;
        }
    }

    private static class CPFloatEntry
    implements CPEntry {
        float val;

        CPFloatEntry(float f) {
            this.val = f;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPFloatEntry)) {
                return false;
            }
            return ((CPFloatEntry)object).val == this.val || Float.isNaN(((CPFloatEntry)object).val) && Float.isNaN(this.val);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(4);
            dataOutput.writeFloat(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPFloatEntry val=" + this.val;
        }
    }

    private static class CPLongEntry
    implements CPEntry {
        long val;

        CPLongEntry(long l) {
            this.val = l;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPLongEntry)) {
                return false;
            }
            return ((CPLongEntry)object).val == this.val;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(5);
            dataOutput.writeLong(this.val);
        }

        public int needSlots() {
            return 2;
        }

        public String toString() {
            return "CPLongEntry val=" + this.val;
        }
    }

    private static class CPIntEntry
    implements CPEntry {
        int val;

        CPIntEntry(int n) {
            this.val = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPIntEntry)) {
                return false;
            }
            return ((CPIntEntry)object).val == this.val;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(3);
            dataOutput.writeInt(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPIntEntry val=" + this.val;
        }
    }

    private static class CPRefEntry
    implements CPEntry {
        byte tag;
        int clazz;
        int name;

        CPRefEntry(byte by, int n, int n2) {
            this.tag = by;
            this.clazz = n;
            this.name = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPRefEntry)) {
                return false;
            }
            CPRefEntry cPRefEntry = (CPRefEntry)object;
            return cPRefEntry.clazz == this.clazz && cPRefEntry.name == this.name && cPRefEntry.tag == this.tag;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.tag);
            dataOutput.writeShort(this.clazz);
            dataOutput.writeShort(this.name);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPRefEntry tag=" + this.tag + " class=" + this.clazz + " name=" + this.name;
        }
    }

    private static class CPTypedStringEntry
    implements CPEntry {
        byte tag;
        int name;

        CPTypedStringEntry(byte by, int n) {
            this.tag = by;
            this.name = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CPTypedStringEntry)) {
                return false;
            }
            CPTypedStringEntry cPTypedStringEntry = (CPTypedStringEntry)object;
            return cPTypedStringEntry.name == this.name && cPTypedStringEntry.tag == this.tag;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.tag);
            dataOutput.writeShort(this.name);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPTypedStringEntry tag=" + this.tag + " name=" + this.name;
        }
    }

    private static interface CPEntry {
        public void write(DataOutput var1) throws IOException;

        public int needSlots();
    }
}

