/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.AbstractSymbol;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

class SimpleSymbol
extends AbstractSymbol
implements Symbol,
Serializable {
    private final char token;
    private final Annotation annotation;
    protected Alphabet matches;

    protected SimpleSymbol(char c, Annotation annotation) {
        this.token = c;
        this.annotation = new SimpleAnnotation(annotation);
    }

    public SimpleSymbol(char c, Annotation annotation, Alphabet alphabet) {
        this(c, annotation);
        if (alphabet == null) {
            throw new NullPointerException("Can't construct SimpleSymbol with a null matches alphabet");
        }
        this.matches = alphabet;
    }

    protected Alphabet createMatches() {
        throw new BioError("Assertion Failure: Matches alphabet is null in " + this);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Alphabet getMatches() {
        if (this.matches == null) {
            this.matches = this.createMatches();
        }
        return this.matches;
    }

    public String getName() {
        Object object;
        Alphabet alphabet = this.getMatches();
        if (this instanceof BasisSymbol && (object = ((BasisSymbol)((Object)this)).getSymbols()).size() > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                stringBuffer.append(symbol.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(' ');
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (alphabet instanceof FiniteAlphabet) {
            object = (FiniteAlphabet)alphabet;
            if (object.size() <= 1) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                stringBuffer.append(symbol.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
        return "Infinite";
    }

    public char getToken() {
        return this.token;
    }
}

