/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.SymbolList;

public class PairDPMatrix
implements DPMatrix,
Serializable {
    private State[] states;
    private SymbolList[] seqs;
    private double[][][] scores;
    private MarkovModel model;
    private double finalScore;

    public PairDPMatrix(DP dP, SymbolList symbolList, SymbolList symbolList2) {
        this.model = dP.getModel();
        this.states = dP.getStates();
        this.seqs = new SymbolList[2];
        this.seqs[0] = symbolList;
        this.seqs[1] = symbolList2;
        this.finalScore = Double.NaN;
        this.scores = new double[symbolList.length() + 2][symbolList2.length() + 2][this.states.length];
    }

    public double getCell(int[] nArray) {
        if (nArray.length != 3) {
            throw new IndexOutOfBoundsException("Index array must be length 3");
        }
        return this.scores[nArray[1]][nArray[2]][nArray[0]];
    }

    public double getScore() {
        return this.finalScore;
    }

    double[][][] getScoreArray() {
        return this.scores;
    }

    public MarkovModel model() {
        return this.model;
    }

    void setScore(double d) {
        this.finalScore = d;
    }

    public State[] states() {
        return this.states;
    }

    public SymbolList[] symList() {
        return this.seqs;
    }
}

