/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ListWrapper;

public class EmissionCache {
    private final Map eMap = new HashMap();
    private final ListWrapper gopher = new ListWrapper();
    private final Alphabet alpha;
    private final State[] states;
    private final int dsi;
    private final ScoreType scoreType;

    public EmissionCache(Alphabet alphabet, State[] stateArray, int n, ScoreType scoreType) {
        this.alpha = alphabet;
        this.states = stateArray;
        this.dsi = n;
        this.scoreType = scoreType;
    }

    public void clear() {
        this.eMap.clear();
    }

    public final double[] getEmissions(List list) throws IllegalSymbolException {
        this.gopher.setList(list);
        double[] dArray = (double[])this.eMap.get(this.gopher);
        if (dArray == null) {
            Symbol[][] symbolArray = new Symbol[2][2];
            ArrayList arrayList = new ArrayList(list);
            Symbol symbol = AlphabetManager.getGapSymbol();
            symbolArray[0][0] = symbol;
            Symbol symbol2 = symbol;
            symbolArray[1][1] = this.alpha.getSymbol(Arrays.asList((Symbol)list.get(0), (Symbol)list.get(1)));
            symbolArray[1][0] = this.alpha.getSymbol(Arrays.asList((Symbol)list.get(0), symbol2));
            symbolArray[0][1] = this.alpha.getSymbol(Arrays.asList(symbol2, (Symbol)list.get(1)));
            dArray = new double[this.dsi];
            int n = 0;
            while (n < this.dsi) {
                EmissionState emissionState = (EmissionState)this.states[n];
                int[] nArray = emissionState.getAdvance();
                Distribution distribution = emissionState.getDistribution();
                Symbol symbol3 = symbolArray[nArray[0]][nArray[1]];
                dArray[n] = Math.log(this.scoreType.calculateScore(distribution, symbol3));
                ++n;
            }
            this.eMap.put(new ListWrapper(arrayList), dArray);
        }
        return dArray;
    }
}

