/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlForm;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.AttributeConverter;
import psidev.psi.mi.xml.converter.impl254.AvailabilityConverter;
import psidev.psi.mi.xml.converter.impl254.ConfidenceConverter;
import psidev.psi.mi.xml.converter.impl254.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl254.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.impl254.InferredInteractionConverter;
import psidev.psi.mi.xml.converter.impl254.InteractionParameterConverter;
import psidev.psi.mi.xml.converter.impl254.NamesConverter;
import psidev.psi.mi.xml.converter.impl254.ParticipantConverter;
import psidev.psi.mi.xml.converter.impl254.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml254.jaxb.AttributeList;
import psidev.psi.mi.xml254.jaxb.Confidence;
import psidev.psi.mi.xml254.jaxb.ConfidenceList;
import psidev.psi.mi.xml254.jaxb.CvType;
import psidev.psi.mi.xml254.jaxb.ExperimentList;
import psidev.psi.mi.xml254.jaxb.InferredInteractionList;
import psidev.psi.mi.xml254.jaxb.Parameter;
import psidev.psi.mi.xml254.jaxb.ParameterList;
import psidev.psi.mi.xml254.jaxb.Participant;
import psidev.psi.mi.xml254.jaxb.ParticipantList;

public class InteractionConverter {
    public static final Log log = LogFactory.getLog(InteractionConverter.class);
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private ConfidenceConverter confidenceConverter = new ConfidenceConverter();
    private ParticipantConverter participantConverter = new ParticipantConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private InteractionParameterConverter parameterConverter = new InteractionParameterConverter();
    private InferredInteractionConverter inferredInteractionConverter = new InferredInteractionConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.parameterConverter.setDAOFactory(factory);
        this.confidenceConverter.setDAOFactory(factory);
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.participantConverter.setDAOFactory(factory);
        this.experimentDescriptionConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Interaction fromJaxb(psidev.psi.mi.xml254.jaxb.Interaction jInteraction) throws ConverterException {
        if (jInteraction == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interaction.");
        }
        this.checkDependencies();
        Interaction mInteraction = new Interaction();
        mInteraction.setId(jInteraction.getId());
        mInteraction.setImexId(jInteraction.getImexId());
        if (jInteraction.getNames() != null) {
            mInteraction.setNames(this.namesConverter.fromJaxb(jInteraction.getNames()));
        }
        if (jInteraction.getXref() != null) {
            mInteraction.setXref(this.xrefConverter.fromJaxb(jInteraction.getXref()));
        }
        if (jInteraction.getAvailability() != null) {
            mInteraction.setAvailability(this.availabilityConverter.fromJaxb(jInteraction.getAvailability()));
        }
        if (jInteraction.getExperimentList() != null) {
            for (Serializable o : jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions()) {
                log.debug("Reading object of type: " + o.getClass());
                ExperimentDescription mExperiment = null;
                ExperimentRef experimentRef = null;
                if (o instanceof psidev.psi.mi.xml254.jaxb.ExperimentDescription) {
                    log.debug("Found an experiment");
                    mExperiment = this.experimentDescriptionConverter.fromJaxb((psidev.psi.mi.xml254.jaxb.ExperimentDescription)o);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    experimentDAO.store(mExperiment);
                } else if (o instanceof Integer) {
                    Integer ref = (Integer)o;
                    experimentRef = new ExperimentRef(ref);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    mExperiment = experimentDAO.retreive((Integer)o);
                } else {
                    throw new IllegalStateException("Expected object type: {psidev.psi.mi.xml254.jaxb.ExperimentDescription, Integer}, found: " + o.getClass().getName());
                }
                if (mExperiment == null) {
                    mInteraction.getExperimentRefs().add(experimentRef);
                    continue;
                }
                mInteraction.getExperiments().add(mExperiment);
            }
        }
        if (jInteraction.getParticipantList() != null) {
            for (Participant jParticipant : jInteraction.getParticipantList().getParticipants()) {
                psidev.psi.mi.xml.model.Participant participant = this.participantConverter.fromJaxb(jParticipant);
                mInteraction.getParticipants().add(participant);
            }
        }
        if (jInteraction.getInferredInteractionList() != null) {
            for (psidev.psi.mi.xml254.jaxb.InferredInteraction jInferredInteraction : jInteraction.getInferredInteractionList().getInferredInteractions()) {
                mInteraction.getInferredInteractions().add(this.inferredInteractionConverter.fromJaxb(jInferredInteraction));
            }
        }
        for (CvType jIntereractionType : jInteraction.getInteractionTypes()) {
            mInteraction.getInteractionTypes().add(this.cvTypeConverter.fromJaxb(jIntereractionType, InteractionType.class));
        }
        if (jInteraction.isModelled() != null) {
            mInteraction.setModelled(jInteraction.isModelled());
        } else {
            mInteraction.setModelled(false);
        }
        if (jInteraction.isIntraMolecular() != null) {
            mInteraction.setIntraMolecular(jInteraction.isIntraMolecular());
        } else {
            mInteraction.setIntraMolecular(false);
        }
        if (jInteraction.isNegative() != null) {
            mInteraction.setNegative(jInteraction.isNegative());
        } else {
            mInteraction.setNegative(false);
        }
        if (jInteraction.getConfidenceList() != null) {
            for (Confidence jConfidence : jInteraction.getConfidenceList().getConfidences()) {
                mInteraction.getConfidences().add(this.confidenceConverter.fromJaxb(jConfidence));
            }
        }
        if (jInteraction.getParameterList() != null) {
            for (Parameter jParameter : jInteraction.getParameterList().getParameters()) {
                mInteraction.getParameters().add(this.parameterConverter.fromJaxb(jParameter));
            }
        }
        if (jInteraction.getAttributeList() != null) {
            for (psidev.psi.mi.xml254.jaxb.Attribute jAttribute : jInteraction.getAttributeList().getAttributes()) {
                mInteraction.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        PsiDAO<Interaction> interactionDAO = this.factory.getInteractionDAO();
        interactionDAO.store(mInteraction);
        return mInteraction;
    }

    public psidev.psi.mi.xml254.jaxb.Interaction toJaxb(Interaction mInteraction) throws ConverterException {
        List<Serializable> ids;
        if (mInteraction == null) {
            throw new IllegalArgumentException("You must give a non null model Interaction.");
        }
        this.checkDependencies();
        psidev.psi.mi.xml254.jaxb.Interaction jInteraction = new psidev.psi.mi.xml254.jaxb.Interaction();
        jInteraction.setId(mInteraction.getId());
        jInteraction.setImexId(mInteraction.getImexId());
        if (mInteraction.hasNames()) {
            jInteraction.setNames(this.namesConverter.toJaxb(mInteraction.getNames()));
        }
        if (mInteraction.hasXref()) {
            jInteraction.setXref(this.xrefConverter.toJaxb(mInteraction.getXref()));
        }
        if (mInteraction.hasAvailability()) {
            jInteraction.setAvailability(this.availabilityConverter.toJaxb(mInteraction.getAvailability()));
        }
        if (PsimiXmlForm.FORM_COMPACT == ConverterContext.getInstance().getConverterConfig().getXmlForm() && mInteraction.hasExperimentRefs()) {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new ExperimentList());
            }
            ids = jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions();
            for (ExperimentRef experimentRef : mInteraction.getExperimentRefs()) {
                if (ids.contains(experimentRef.getRef())) continue;
                ids.add(Integer.valueOf(experimentRef.getRef()));
            }
        } else {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new ExperimentList());
            }
            ids = jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions();
            for (ExperimentDescription experimentDescription : mInteraction.getExperiments()) {
                psidev.psi.mi.xml254.jaxb.ExperimentDescription exp = this.experimentDescriptionConverter.toJaxb(experimentDescription);
                if (PsimiXmlForm.FORM_COMPACT == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
                    if (ids.contains(experimentDescription.getId())) continue;
                    ids.add(Integer.valueOf(experimentDescription.getId()));
                    continue;
                }
                if (ids.contains(exp)) continue;
                ids.add(exp);
            }
        }
        if (mInteraction.getParticipants() != null) {
            if (jInteraction.getParticipantList() == null) {
                jInteraction.setParticipantList(new ParticipantList());
            }
            for (psidev.psi.mi.xml.model.Participant mParticipant : mInteraction.getParticipants()) {
                jInteraction.getParticipantList().getParticipants().add(this.participantConverter.toJaxb(mParticipant));
            }
        }
        if (mInteraction.hasInferredInteractions()) {
            if (jInteraction.getInferredInteractionList() == null) {
                jInteraction.setInferredInteractionList(new InferredInteractionList());
            }
            for (InferredInteraction inferredInteraction : mInteraction.getInferredInteractions()) {
                jInteraction.getInferredInteractionList().getInferredInteractions().add(this.inferredInteractionConverter.toJaxb(inferredInteraction));
            }
        }
        if (mInteraction.hasInteractionTypes()) {
            for (InteractionType mInteractionType : mInteraction.getInteractionTypes()) {
                jInteraction.getInteractionTypes().add(this.cvTypeConverter.toJaxb(mInteractionType));
            }
        }
        if (mInteraction.hasParameters()) {
            if (jInteraction.getParameterList() == null) {
                jInteraction.setParameterList(new ParameterList());
            }
            for (psidev.psi.mi.xml.model.Parameter mParameter : mInteraction.getParameters()) {
                jInteraction.getParameterList().getParameters().add(this.parameterConverter.toJaxb(mParameter));
            }
        }
        jInteraction.setIntraMolecular(mInteraction.isIntraMolecular());
        jInteraction.setModelled(mInteraction.isModelled());
        jInteraction.setNegative(mInteraction.isNegative());
        if (mInteraction.hasConfidences()) {
            if (jInteraction.getConfidenceList() == null) {
                jInteraction.setConfidenceList(new ConfidenceList());
            }
            for (psidev.psi.mi.xml.model.Confidence mConfidence : mInteraction.getConfidences()) {
                jInteraction.getConfidenceList().getConfidences().add(this.confidenceConverter.toJaxb(mConfidence));
            }
        }
        if (mInteraction.hasAttributes()) {
            if (jInteraction.getAttributeList() == null) {
                jInteraction.setAttributeList(new AttributeList());
            }
            for (Attribute mAttribute : mInteraction.getAttributes()) {
                jInteraction.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        return jInteraction;
    }
}

