/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.ArrayList;
import java.util.List;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.Organism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganismImpl
implements Organism {
    private static final long serialVersionUID = 5647365864375422507L;
    List<CrossReference> identifiers = new ArrayList<CrossReference>();

    public OrganismImpl() {
    }

    public OrganismImpl(CrossReference ref) {
        this.addIdentifier(ref);
    }

    public OrganismImpl(List<CrossReference> identifiers) {
        this.setIdentifiers(identifiers);
    }

    public OrganismImpl(int taxid) {
        this.addIdentifier(new CrossReferenceImpl("taxid", String.valueOf(taxid)));
    }

    public OrganismImpl(int taxid, String name) {
        this.addIdentifier(new CrossReferenceImpl("taxid", String.valueOf(taxid), name));
    }

    @Override
    public void addIdentifier(CrossReference ref) {
        this.identifiers.add(ref);
    }

    @Override
    public List<CrossReference> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(List<CrossReference> identifiers) {
        if (identifiers == null) {
            throw new IllegalArgumentException("Identifiers cannot be null.");
        }
        this.identifiers.addAll(identifiers);
    }

    @Override
    public String getTaxid() {
        for (CrossReference crossReference : this.identifiers) {
            if (!"taxid".equals(crossReference.getDatabase())) continue;
            return crossReference.getIdentifier();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Organism");
        sb.append("{identifiers=").append(this.identifiers);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganismImpl organism = (OrganismImpl)o;
        return ((Object)this.identifiers).equals(organism.identifiers);
    }

    public int hashCode() {
        return ((Object)this.identifiers).hashCode();
    }
}

