/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import psidev.psi.mi.tab.model.Annotation;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Checksum;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryInteraction<T extends Interactor>
implements BinaryInteraction<T> {
    private static final long serialVersionUID = 5851048278405255668L;
    private T interactorA;
    private T interactorB;
    private List<CrossReference> detectionMethods = new ArrayList<CrossReference>();
    private List<CrossReference> interactionTypes = new ArrayList<CrossReference>();
    private List<CrossReference> publications = new ArrayList<CrossReference>();
    private List<Confidence> confidenceValues = new ArrayList<Confidence>();
    private List<CrossReference> sourceDatabases = new ArrayList<CrossReference>();
    private List<CrossReference> interactionAcs = new ArrayList<CrossReference>();
    private List<Author> authors = new ArrayList<Author>();
    private List<CrossReference> complexExpansion = new ArrayList<CrossReference>();
    private List<CrossReference> interactionXrefs = new ArrayList<CrossReference>();
    private List<Annotation> interactionAnnotations = new ArrayList<Annotation>();
    private Organism hostOrganism;
    private List<Parameter> interactionParameters = new ArrayList<Parameter>();
    private List<Date> creationDate = new ArrayList<Date>();
    private List<Date> updateDate = new ArrayList<Date>();
    private List<Checksum> interactionChecksums = new ArrayList<Checksum>();
    private boolean negativeInteraction;

    public AbstractBinaryInteraction() {
    }

    public AbstractBinaryInteraction(T interactor) {
        this.setInteractorA(interactor);
    }

    public AbstractBinaryInteraction(T interactorA, T interactorB) {
        this.setInteractorA(interactorA);
        this.setInteractorB(interactorB);
    }

    @Override
    public void flip() {
        T interactorA = this.getInteractorA();
        T interactorB = this.getInteractorB();
        this.setInteractorA(interactorB);
        this.setInteractorB(interactorA);
    }

    @Override
    public T getInteractorA() {
        return this.interactorA;
    }

    @Override
    public void setInteractorA(T interactorA) {
        this.interactorA = interactorA;
    }

    @Override
    public T getInteractorB() {
        return this.interactorB;
    }

    @Override
    public void setInteractorB(T interactorB) {
        this.interactorB = interactorB;
    }

    @Override
    public List<CrossReference> getDetectionMethods() {
        return this.detectionMethods;
    }

    @Override
    public void setDetectionMethods(List<CrossReference> detectionMethods) {
        this.detectionMethods = detectionMethods;
    }

    @Override
    public List<CrossReference> getInteractionTypes() {
        return this.interactionTypes;
    }

    @Override
    public void setInteractionTypes(List<CrossReference> interactionTypes) {
        this.interactionTypes = interactionTypes;
    }

    @Override
    public List<CrossReference> getPublications() {
        return this.publications;
    }

    @Override
    public void setPublications(List<CrossReference> publications) {
        this.publications = publications;
    }

    @Override
    public List<Confidence> getConfidenceValues() {
        return this.confidenceValues;
    }

    @Override
    public void setConfidenceValues(List<Confidence> confidenceValues) {
        this.confidenceValues = confidenceValues;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    @Override
    public List<CrossReference> getSourceDatabases() {
        return this.sourceDatabases;
    }

    @Override
    public void setSourceDatabases(List<CrossReference> sourceDatabases) {
        this.sourceDatabases = sourceDatabases;
    }

    @Override
    public List<CrossReference> getInteractionAcs() {
        return this.interactionAcs;
    }

    @Override
    public void setInteractionAcs(List<CrossReference> interactionAcs) {
        this.interactionAcs = interactionAcs;
    }

    @Override
    public List<CrossReference> getComplexExpansion() {
        return this.complexExpansion;
    }

    @Override
    public void setComplexExpansion(List<CrossReference> complexExpansion) {
        this.complexExpansion = complexExpansion;
    }

    @Override
    public List<CrossReference> getXrefs() {
        return this.interactionXrefs;
    }

    @Override
    public void setXrefs(List<CrossReference> xrefs) {
        this.interactionXrefs = xrefs;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.interactionAnnotations;
    }

    @Override
    public void setAnnotations(List<Annotation> interactionAnnotations) {
        this.interactionAnnotations = interactionAnnotations;
    }

    @Override
    public Organism getHostOrganism() {
        return this.hostOrganism;
    }

    @Override
    public void setHostOrganism(Organism hostOrganism) {
        this.hostOrganism = hostOrganism;
    }

    @Override
    public boolean hasHostOrganism() {
        return this.hostOrganism != null;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.interactionParameters;
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.interactionParameters = parameters;
    }

    @Override
    public List<Date> getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(List<Date> creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public List<Date> getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public void setUpdateDate(List<Date> updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public List<Checksum> getChecksums() {
        return this.interactionChecksums;
    }

    @Override
    public void setChecksums(List<Checksum> interactionChecksums) {
        this.interactionChecksums = interactionChecksums;
    }

    @Override
    public boolean isNegativeInteraction() {
        return this.negativeInteraction;
    }

    @Override
    public void setNegativeInteraction(Boolean negativeInteraction) {
        this.negativeInteraction = negativeInteraction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{interactorA=").append(this.interactorA);
        sb.append(", interactorB=").append(this.interactorB);
        sb.append(", detectionMethods=").append(this.detectionMethods);
        sb.append(", interactionTypes=").append(this.interactionTypes);
        sb.append(", authors=").append(this.authors);
        sb.append(", publications=").append(this.publications);
        sb.append(", confidenceValues=").append(this.confidenceValues);
        sb.append(", sourceDatabases=").append(this.sourceDatabases);
        sb.append(", interactionAcs=").append(this.interactionAcs);
        sb.append(", complexExpansion=").append(this.complexExpansion);
        sb.append(", xrefs=").append(this.interactionXrefs);
        sb.append(", annotations=").append(this.interactionAnnotations);
        sb.append(", hostOrganism=").append(this.hostOrganism);
        sb.append(", parameters=").append(this.interactionParameters);
        sb.append(", creationDate=").append(this.creationDate);
        sb.append(", updateDate=").append(this.updateDate);
        sb.append(", checksums=").append(this.interactionChecksums);
        sb.append(", negative=").append(this.negativeInteraction);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBinaryInteraction that = (AbstractBinaryInteraction)o;
        if (this.detectionMethods != null ? !((Object)this.detectionMethods).equals(that.detectionMethods) : that.detectionMethods != null) {
            return false;
        }
        if (this.interactionTypes != null ? !((Object)this.interactionTypes).equals(that.interactionTypes) : that.interactionTypes != null) {
            return false;
        }
        if (this.interactorA == null) {
            if (that.interactorA != null && that.interactorB != null) {
                return false;
            }
            if (that.interactorA == null ? !((Interactor)this.interactorB).equals(that.interactorB) : that.interactorB == null && !((Interactor)this.interactorB).equals(that.interactorA)) {
                return false;
            }
        } else if (this.interactorB == null) {
            if (that.interactorB != null && that.interactorA != null) {
                return false;
            }
            if (that.interactorB == null ? !((Interactor)this.interactorA).equals(that.interactorA) : this.interactorB == null && that.interactorA == null && !((Interactor)this.interactorA).equals(that.interactorB)) {
                return false;
            }
        } else if (this.interactorA != null && this.interactorB != null) {
            boolean part2;
            boolean part1 = ((Interactor)this.interactorA).equals(that.interactorA) && ((Interactor)this.interactorB).equals(that.interactorB);
            boolean bl = part2 = ((Interactor)this.interactorB).equals(that.interactorA) && ((Interactor)this.interactorA).equals(that.interactorB);
            if (!part1 && !part2) {
                return false;
            }
        }
        if (this.publications != null ? !CollectionUtils.isEqualCollection(this.publications, that.publications) : that.publications != null) {
            return false;
        }
        if (this.confidenceValues != null ? !CollectionUtils.isEqualCollection(this.confidenceValues, that.confidenceValues) : that.confidenceValues != null) {
            return false;
        }
        if (this.sourceDatabases != null ? !CollectionUtils.isEqualCollection(this.sourceDatabases, that.sourceDatabases) : that.sourceDatabases != null) {
            return false;
        }
        if (this.interactionAcs != null ? !CollectionUtils.isEqualCollection(this.interactionAcs, that.interactionAcs) : that.interactionAcs != null) {
            return false;
        }
        if (this.authors != null ? !CollectionUtils.isEqualCollection(this.authors, that.authors) : that.authors != null) {
            return false;
        }
        if (this.complexExpansion != null ? !CollectionUtils.isEqualCollection(this.complexExpansion, that.complexExpansion) : that.complexExpansion != null) {
            return false;
        }
        if (this.interactionXrefs != null ? !CollectionUtils.isEqualCollection(this.interactionXrefs, that.interactionXrefs) : that.interactionXrefs != null) {
            return false;
        }
        if (this.interactionAnnotations != null ? !CollectionUtils.isEqualCollection(this.interactionAnnotations, that.interactionAnnotations) : that.interactionAnnotations != null) {
            return false;
        }
        if (this.hostOrganism != null ? !this.hostOrganism.equals(that.hostOrganism) : that.hostOrganism != null) {
            return false;
        }
        if (this.interactionParameters != null ? !CollectionUtils.isEqualCollection(this.interactionParameters, that.interactionParameters) : that.interactionParameters != null) {
            return false;
        }
        if (this.creationDate != null ? !CollectionUtils.isEqualCollection(this.creationDate, that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.updateDate != null ? !CollectionUtils.isEqualCollection(this.updateDate, that.updateDate) : that.updateDate != null) {
            return false;
        }
        if (this.interactionChecksums != null ? !CollectionUtils.isEqualCollection(this.interactionChecksums, that.interactionChecksums) : that.interactionChecksums != null) {
            return false;
        }
        return this.negativeInteraction == that.negativeInteraction;
    }

    public int hashCode() {
        int result = ((Interactor)this.interactorA).hashCode() * ((Interactor)this.interactorB).hashCode();
        result = 31 * result + (this.detectionMethods != null ? ((Object)this.detectionMethods).hashCode() : 0);
        result = 31 * result + (this.interactionTypes != null ? ((Object)this.interactionTypes).hashCode() : 0);
        result = 31 * result + (this.publications != null ? ((Object)this.publications).hashCode() : 0);
        result = 31 * result + (this.confidenceValues != null ? ((Object)this.confidenceValues).hashCode() : 0);
        result = 31 * result + (this.sourceDatabases != null ? ((Object)this.sourceDatabases).hashCode() : 0);
        result = 31 * result + (this.interactionAcs != null ? ((Object)this.interactionAcs).hashCode() : 0);
        result = 31 * result + (this.authors != null ? ((Object)this.authors).hashCode() : 0);
        result = 31 * result + (this.sourceDatabases != null ? ((Object)this.sourceDatabases).hashCode() : 0);
        result = 31 * result + (this.complexExpansion != null ? ((Object)this.complexExpansion).hashCode() : 0);
        result = 31 * result + (this.interactionXrefs != null ? ((Object)this.interactionXrefs).hashCode() : 0);
        result = 31 * result + (this.interactionAnnotations != null ? ((Object)this.interactionAnnotations).hashCode() : 0);
        result = 31 * result + (this.hostOrganism != null ? this.hostOrganism.hashCode() : 0);
        result = 31 * result + (this.interactionParameters != null ? ((Object)this.interactionParameters).hashCode() : 0);
        result = 31 * result + (this.creationDate != null ? ((Object)this.creationDate).hashCode() : 0);
        result = 31 * result + (this.updateDate != null ? ((Object)this.updateDate).hashCode() : 0);
        result = 31 * result + (this.interactionChecksums != null ? ((Object)this.interactionChecksums).hashCode() : 0);
        return result;
    }
}

