/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.HashMap;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;

public class GraphMLWriter {
    private String filePath;
    private FileWriter fstream;
    private BufferedWriter out;
    private HashMap map;
    private final short INITIAL_INDENTATION = (short)4;
    private final String FILE_HEADER = "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\">\n  <key id=\"x\" for=\"node\" attr.name=\"x\" attr.type=\"int\"/>\n  <key id=\"y\" for=\"node\" attr.name=\"y\" attr.type=\"int\"/>\n  <key id=\"height\" for=\"node\" attr.name=\"height\" attr.type=\"int\"/>\n  <key id=\"width\" for=\"node\" attr.name=\"width\" attr.type=\"int\"/>\n  <key id=\"shape\" for=\"node\" attr.name=\"shape\" attr.type=\"string\"/>\n  <key id=\"clusterID\" for=\"node\" attr.name=\"clusterID\" attr.type=\"string\"/>\n  <key id=\"margin\" for=\"graph\" attr.name=\"margin\" attr.type=\"int\"/>\n  <key id=\"style\" for=\"edge\" attr.name=\"style\" attr.type=\"string\"/>\n  <key id=\"arrow\" for=\"edge\" attr.name=\"arrow\" attr.type=\"string\"/>\n  <key id=\"bendpoint\" for=\"edge\" attr.name=\"bendpoint\" attr.type=\"string\"/>\n  <key id=\"color\" for=\"all\" attr.name=\"color\" attr.type=\"string\"/>\n  <key id=\"borderColor\" for=\"all\" attr.name=\"borderColor\" attr.type=\"string\"/>\n  <key id=\"text\" for=\"all\" attr.name=\"text\" attr.type=\"string\"/>\n  <key id=\"textFont\" for=\"all\" attr.name=\"textFont\" attr.type=\"string\"/>\n  <key id=\"textColor\" for=\"all\" attr.name=\"textColor\" attr.type=\"string\"/>\n  <key id=\"highlightColor\" for=\"all\" attr.name=\"highlightColor\" attr.type=\"string\"/>\n";
    private final String[] NODE_DATA_1 = new String[]{"<data key=\"color\">14 112 130</data>\n", "<data key=\"borderColor\">14 112 130</data>\n"};
    private final String[] NODE_DATA_2 = new String[]{"<data key=\"textFont\">1|Arial|8.25|0|WINDOWS|1|-11|0|0|0|0|0|0|0|1|0|0|0|0|Arial</data>\n", "<data key=\"textColor\">0 0 0</data>\n", "<data key=\"clusterID\">0</data>\n"};
    private final String[] EDGE_DATA = new String[]{"<data key=\"color\">0 0 0</data>\n", "<data key=\"text\"/>\n", "<data key=\"textFont\">1|Arial|8|0|WINDOWS|1|-11|0|0|0|0|0|0|0|1|0|0|0|0|Arial</data>\n", "<data key=\"textColor\">0 0 0</data>\n", "<data key=\"style\">Solid</data>\n", "<data key=\"arrow\">None</data>\n", "<data key=\"width\">1</data>\n"};
    private final String FILE_FOOTER = "    <data key=\"margin\">-1</data>\n  </graph>\n</graphml>";

    public GraphMLWriter(String _filePath) {
        this.filePath = _filePath;
        this.map = new HashMap();
        try {
            this.fstream = new FileWriter(this.filePath);
            this.out = new BufferedWriter(this.fstream);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void saveGraph(LGraphManager lgm) {
        try {
            this.out.write(this.FILE_HEADER);
            this.mapNodes(lgm.getRoot(), (short)0, "");
            this.writeNodes(lgm.getRoot(), (short)0, "");
            this.writeEdges(lgm);
            this.out.write(this.FILE_FOOTER);
            this.out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void mapNodes(LGraph root, short level, String parentStr) {
        for (int i = 0; i < root.getNodes().size(); ++i) {
            LNode node = (LNode)root.getNodes().get(i);
            String currNodeStr = level != 0 ? parentStr + ":n" + i : "n" + i;
            this.map.put(node, currNodeStr);
            if (node.getChild() == null) continue;
            this.mapNodes(node.getChild(), (short)(level + 1), currNodeStr);
        }
    }

    private void writeNodes(LGraph root, short level, String parentStr) {
        short currIndentation = (short)(this.INITIAL_INDENTATION + level * 2);
        LNode parent = root.getParent();
        try {
            this.writeSpaces((short)(currIndentation - 2));
            if (level == 0) {
                this.out.write("<graph id=\"\" edgedefault=\"undirected\">\n");
            } else {
                this.out.write("  <graph id=\"" + parentStr + ":\" edgedefault=\"undirected\">\n");
            }
            for (int i = 0; i < root.getNodes().size(); ++i) {
                int y;
                int x;
                LNode node = (LNode)root.getNodes().get(i);
                if (parent == null) {
                    x = (int)node.getRect().x;
                    y = (int)node.getRect().y;
                } else {
                    x = (int)(node.getRect().x - parent.getRect().x);
                    y = (int)(node.getRect().y - parent.getRect().y);
                }
                this.writeSpaces(currIndentation);
                this.out.write("<node id=\"");
                String currNodeStr = (String)this.map.get(node);
                this.out.write(currNodeStr + "\">\n");
                this.writeSpaces((short)(currIndentation + 2));
                this.out.write("<data key=\"x\">" + x + "</data>\n");
                this.writeSpaces((short)(currIndentation + 2));
                this.out.write("<data key=\"y\">" + y + "</data>\n");
                this.writeSpaces((short)(currIndentation + 2));
                this.out.write("<data key=\"height\">" + (int)node.getRect().height + "</data>\n");
                this.writeSpaces((short)(currIndentation + 2));
                this.out.write("<data key=\"width\">" + (int)node.getRect().width + "</data>\n");
                this.writeToFile(this.NODE_DATA_1, (short)(currIndentation + 2));
                this.writeSpaces((short)(currIndentation + 2));
                this.out.write("<data key=\"text\">" + currNodeStr + "</data>\n");
                this.writeToFile(this.NODE_DATA_2, (short)(currIndentation + 2));
                if (node.getChild() != null) {
                    this.writeNodes(node.getChild(), (short)(level + 1), currNodeStr);
                } else {
                    this.writeSpaces((short)(currIndentation + 2));
                    this.out.write("<data key=\"shape\">Rectangle</data>\n");
                }
                this.writeSpaces(currIndentation);
                this.out.write("</node>\n");
            }
            if (level != 0) {
                this.writeSpaces(currIndentation);
                this.out.write("<data key=\"margin\">10</data>\n");
                this.writeSpaces((short)(currIndentation - 2));
                this.out.write("</graph>\n");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void writeEdges(LGraphManager lgm) {
        try {
            for (int i = 0; i < lgm.getAllEdges().length; ++i) {
                LEdge edge = (LEdge)lgm.getAllEdges()[i];
                String sourceStr = (String)this.map.get(edge.getSource());
                String targetStr = (String)this.map.get(edge.getTarget());
                this.out.write("    <edge id=\"e" + i + "\" source=\"" + sourceStr + "\" target=\"" + targetStr + "\">\n");
                this.writeToFile(this.EDGE_DATA, (short)6);
                this.out.write("    </edge>\n");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void writeSpaces(short n) {
        try {
            for (int i = 0; i < n; ++i) {
                this.out.write(" ");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void writeToFile(String[] inp, short n) {
        try {
            for (int i = 0; i < inp.length; ++i) {
                this.writeSpaces(n);
                this.out.write(inp[i]);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

