/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.spring.SpringConstants;
import org.ivis.layout.spring.SpringNode;
import org.ivis.layout.spring.SpringNodeDistances;
import org.ivis.util.PointD;

public class SpringLayout
extends Layout {
    protected int numLayoutPasses;
    protected int nodeCount;
    protected int layoutPass;
    protected double averageIterationsPerNode;
    protected double nodeDistanceStrengthConstant;
    protected double nodeDistanceRestLengthConstant;
    protected double disconnectedNodeDistanceSpringStrength;
    protected double[] nodeDistanceSpringScalars = SpringConstants.DEFAULT_NODE_DISTANCE_SPRING_SCALARS;
    protected double[] anticollisionSpringScalars = SpringConstants.DEFAULT_ANTICOLLISION_SPRING_SCALARS;
    protected double disconnectedNodeDistanceSpringRestLength;
    protected double anticollisionSpringStrength;
    protected double[][] nodeDistanceSpringStrengths;
    protected double[][] nodeDistanceSpringRestLengths;
    List nodeList;
    public double totalEnergy = 0.0;

    public void doLayout() {
        this.nodeList = new ArrayList();
        for (Object obj : this.getGraphManager().getAllNodes()) {
            LNode node = (LNode)obj;
            if (node.getChild() != null) continue;
            this.nodeList.add(node);
        }
        this.nodeCount = this.nodeList.size();
        int edgeCount = this.getGraphManager().getAllEdges().length;
        double euclidean_distance_threshold = 0.5 * (double)(this.nodeCount + edgeCount);
        int num_iterations = (int)((double)this.nodeCount * this.averageIterationsPerNode / (double)this.numLayoutPasses);
        ArrayList<SpringNode> partials_list = new ArrayList<SpringNode>();
        SpringNode furthest_node_partials = null;
        this.layoutPass = 0;
        while (this.layoutPass < this.numLayoutPasses) {
            this.setupNodeDistanceSprings();
            this.totalEnergy = 0.0;
            partials_list.clear();
            for (SpringNode partials : this.nodeList) {
                this.calculatePartials(partials, null, false);
                partials_list.add(partials);
                if (furthest_node_partials != null && !(partials.euclideanDistance > furthest_node_partials.euclideanDistance)) continue;
                furthest_node_partials = partials;
            }
            for (int iterations_i = 0; iterations_i < num_iterations && furthest_node_partials.euclideanDistance >= euclidean_distance_threshold; ++iterations_i) {
                furthest_node_partials = this.moveNode(furthest_node_partials, partials_list);
            }
            ++this.layoutPass;
        }
        List graphs = this.graphManager.getGraphs();
        for (int i = 0; i < graphs.size() - 1; ++i) {
            LGraph graph = (LGraph)graphs.get(i);
            graph.getParent().updateBounds();
        }
    }

    protected void setupNodeDistanceSprings() {
        if (this.layoutPass != 0) {
            return;
        }
        this.nodeDistanceSpringRestLengths = new double[this.nodeCount][this.nodeCount];
        this.nodeDistanceSpringStrengths = new double[this.nodeCount][this.nodeCount];
        if (this.nodeDistanceSpringScalars[this.layoutPass] == 0.0) {
            return;
        }
        SpringNodeDistances ind = new SpringNodeDistances(this.nodeList);
        int[][] node_distances = ind.calculate();
        if (node_distances == null) {
            return;
        }
        double node_distance_strength_constant = this.nodeDistanceStrengthConstant;
        double node_distance_rest_length_constant = this.nodeDistanceRestLengthConstant;
        for (int node_i = 0; node_i < this.nodeCount; ++node_i) {
            for (int node_j = node_i + 1; node_j < this.nodeCount; ++node_j) {
                this.nodeDistanceSpringRestLengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringRestLength : node_distance_rest_length_constant * (double)node_distances[node_i][node_j];
                this.nodeDistanceSpringRestLengths[node_j][node_i] = this.nodeDistanceSpringRestLengths[node_i][node_j];
                this.nodeDistanceSpringStrengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringStrength : node_distance_strength_constant / (double)(node_distances[node_i][node_j] * node_distances[node_i][node_j]);
                this.nodeDistanceSpringStrengths[node_j][node_i] = this.nodeDistanceSpringStrengths[node_i][node_j];
            }
        }
    }

    protected SpringNode calculatePartials(SpringNode partials, List partials_list, boolean reversed) {
        partials.reset();
        SpringNode node = partials;
        int node_view_index = this.nodeList.indexOf(node);
        double node_view_radius = node.getWidth();
        double node_view_x = node.getRect().x;
        double node_view_y = node.getRect().y;
        SpringNode other_node_partials = null;
        SpringNode furthest_partials = null;
        Iterator iterator = partials_list == null ? this.nodeList.iterator() : partials_list.iterator();
        while (iterator.hasNext()) {
            LNode other_node;
            if (partials_list == null) {
                other_node = (LNode)iterator.next();
            } else {
                other_node_partials = (SpringNode)iterator.next();
                other_node = other_node_partials;
            }
            if (this.nodeList.indexOf(node) == this.nodeList.indexOf(other_node)) continue;
            int other_node_view_index = this.nodeList.indexOf(other_node);
            double other_node_view_radius = other_node.getWidth();
            double delta_x = node_view_x - other_node.getRect().x;
            double delta_y = node_view_y - other_node.getRect().y;
            double euclidean_distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y);
            double euclidean_distance_cubed = Math.pow(euclidean_distance, 3.0);
            double distance_from_touching = euclidean_distance - (node_view_radius + other_node_view_radius);
            double incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_x - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_x / euclidean_distance));
            if (!reversed) {
                partials.x += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_x - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_x / euclidean_distance));
                other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_x - (node_view_radius + other_node_view_radius) * delta_x / euclidean_distance));
                if (!reversed) {
                    partials.x += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_x - (node_view_radius + other_node_view_radius) * -delta_x / euclidean_distance));
                    other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_y - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_y / euclidean_distance));
            if (!reversed) {
                partials.y += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_y - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_y / euclidean_distance));
                other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_y - (node_view_radius + other_node_view_radius) * delta_y / euclidean_distance));
                if (!reversed) {
                    partials.y += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_y - (node_view_radius + other_node_view_radius) * -delta_y / euclidean_distance));
                    other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_y * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xx -= incremental_change;
                }
            } else {
                partials.xx += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xx += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_y * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xx -= incremental_change;
                    }
                } else {
                    partials.xx += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xx += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_x) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.yy -= incremental_change;
                }
            } else {
                partials.yy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.yy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_x * delta_x) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.yy -= incremental_change;
                    }
                } else {
                    partials.yy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.yy += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xy -= incremental_change;
                }
            } else {
                partials.xy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * ((node_view_radius + other_node_view_radius) * (delta_x * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xy -= incremental_change;
                    }
                } else {
                    partials.xy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xy += incremental_change;
                    }
                }
            }
            double distance_from_rest = euclidean_distance - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index];
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (distance_from_rest * distance_from_rest) / 2.0);
            if (reversed) {
                if (other_node_partials != null) {
                    this.totalEnergy -= incremental_change;
                }
            } else {
                this.totalEnergy += incremental_change;
                if (other_node_partials != null) {
                    this.totalEnergy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (distance_from_touching * distance_from_touching) / 2.0);
                if (reversed) {
                    if (other_node_partials != null) {
                        this.totalEnergy -= incremental_change;
                    }
                } else {
                    this.totalEnergy += incremental_change;
                    if (other_node_partials != null) {
                        this.totalEnergy += incremental_change;
                    }
                }
            }
            if (other_node_partials == null) continue;
            other_node_partials.euclideanDistance = Math.sqrt(other_node_partials.x * other_node_partials.x + other_node_partials.y * other_node_partials.y);
            if (furthest_partials != null && !(other_node_partials.euclideanDistance > furthest_partials.euclideanDistance)) continue;
            furthest_partials = other_node_partials;
        }
        if (!reversed) {
            partials.euclideanDistance = Math.sqrt(partials.x * partials.x + partials.y * partials.y);
        }
        if (furthest_partials == null || partials.euclideanDistance > furthest_partials.euclideanDistance) {
            furthest_partials = partials;
        }
        return furthest_partials;
    }

    protected SpringNode moveNode(SpringNode partials, List partials_list) {
        SpringNode starting_partials = new SpringNode(partials);
        this.calculatePartials(partials, partials_list, true);
        this.simpleMoveNode(starting_partials, partials);
        return this.calculatePartials(partials, partials_list, false);
    }

    protected void simpleMoveNode(SpringNode partialsInfo, SpringNode partials) {
        double denomenator = partialsInfo.xx * partialsInfo.yy - partialsInfo.xy * partialsInfo.xy;
        double delta_x = (-partialsInfo.x * partialsInfo.yy - -partialsInfo.y * partialsInfo.xy) / denomenator;
        double delta_y = (-partialsInfo.y * partialsInfo.xx - -partialsInfo.x * partialsInfo.xy) / denomenator;
        PointD p = partials.getLocation();
        partials.setLocation(p.x + delta_x, p.y + delta_y);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new SpringNode(this.graphManager, vNode);
    }

    @Override
    public boolean layout() {
        if (!this.incremental) {
            this.positionNodesRandomly();
        }
        this.doLayout();
        return true;
    }

    @Override
    public void initParameters() {
        super.initParameters();
        LayoutOptionsPack.Spring layoutOptionsPack = LayoutOptionsPack.getInstance().getSpring();
        this.nodeDistanceStrengthConstant = 15.0;
        this.disconnectedNodeDistanceSpringStrength = 0.05;
        this.anticollisionSpringStrength = 100.0;
        this.nodeDistanceRestLengthConstant = layoutOptionsPack.nodeDistanceRestLength;
        this.disconnectedNodeDistanceSpringRestLength = layoutOptionsPack.disconnectedNodeDistanceSpringRestLength;
        if (this.layoutQuality == 1) {
            this.numLayoutPasses = 4;
            this.averageIterationsPerNode = 40.0;
        } else if (this.layoutQuality == 2) {
            this.numLayoutPasses = 2;
            this.averageIterationsPerNode = 20.0;
        } else {
            this.numLayoutPasses = 6;
            this.averageIterationsPerNode = 60.0;
        }
    }
}

