/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.six;

import org.ivis.layout.LGraphManager;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;
import org.ivis.layout.cise.CircularForce;
import org.ivis.layout.six.SixCircularCircle;
import org.ivis.layout.six.SixCircularLayout;
import org.ivis.util.IMath;

public class SixCircularNode
extends CiSENode {
    public SixCircularNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    @Override
    public void move() {
        SixCircularLayout layout = (SixCircularLayout)this.graphManager.getLayout();
        this.displacementX = layout.coolingFactor * (this.springForceX + this.repulsionForceX);
        this.displacementY = layout.coolingFactor * (this.springForceY + this.repulsionForceY);
        if (Math.abs(this.displacementX) > layout.maxNodeDisplacement) {
            this.displacementX = layout.maxNodeDisplacement * (double)IMath.sign(this.displacementX);
        }
        if (Math.abs(this.displacementY) > layout.maxNodeDisplacement) {
            this.displacementY = layout.maxNodeDisplacement * (double)IMath.sign(this.displacementY);
        }
        assert (this.child == null);
        SixCircularCircle circle = (SixCircularCircle)this.owner;
        CircularForce circularForce = circle.decomposeForce(this);
        CiSEOnCircleNodeExt onCircleNodeExt = this.getOnCircleNodeExt();
        double theta = circularForce.getRotationAmount() / circle.getRadius() / 15.0;
        onCircleNodeExt.setAngle(onCircleNodeExt.getAngle() + theta);
        onCircleNodeExt.updatePosition();
        layout.totalDisplacement += circularForce.getRotationAmount();
        this.springForceX = 0.0;
        this.springForceY = 0.0;
        this.repulsionForceX = 0.0;
        this.repulsionForceY = 0.0;
        this.displacementX = 0.0;
        this.displacementY = 0.0;
    }
}

