/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sgym;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;

public class SgymNode
extends LNode
implements Comparable {
    protected boolean visited;
    private double edgeCrossesIndicator = 0.0;
    private int additions = 0;
    int gridPosition = 0;
    int priority = 0;
    int color = 0;
    SgymNode ancestor = null;
    public int rank = -1;
    public static int levelSize;

    public SgymNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public SgymNode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(gm, loc, size, vNode);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.visited = false;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    void resetEdgeCrossesIndicator() {
        this.edgeCrossesIndicator = 0.0;
        this.additions = 0;
    }

    double getEdgeCrossesIndicator() {
        if (this.additions == 0) {
            return 0.0;
        }
        return this.edgeCrossesIndicator / (double)this.additions;
    }

    void addToEdgeCrossesIndicator(double addValue) {
        this.edgeCrossesIndicator += addValue;
        ++this.additions;
    }

    public int getLevel() {
        return levelSize - this.rank - 1;
    }

    public void setLevel(int level) {
        this.rank = levelSize - level - 1;
    }

    int getGridPosition() {
        return this.gridPosition;
    }

    void setGridPosition(int pos) {
        this.gridPosition = pos;
    }

    void incrementPriority() {
        ++this.priority;
    }

    int getPriority() {
        return this.priority;
    }

    public int compareTo(Object compare) {
        if (((SgymNode)compare).getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
            return 0;
        }
        double compareValue = ((SgymNode)compare).getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
        return (int)(compareValue * 1000.0);
    }

    public Collection getOutEdges() {
        ArrayList<LEdge> outEdges = new ArrayList<LEdge>();
        List edges = this.getEdges();
        for (int i = 0; i < edges.size(); ++i) {
            LEdge edge = (LEdge)edges.get(i);
            if (edge.getSource() != this) continue;
            outEdges.add(edge);
        }
        return outEdges;
    }

    public Collection getInEdges() {
        ArrayList<LEdge> inEdges = new ArrayList<LEdge>();
        List edges = this.getEdges();
        for (int i = 0; i < edges.size(); ++i) {
            LEdge edge = (LEdge)edges.get(i);
            if (edge.getTarget() != this) continue;
            inEdges.add(edge);
        }
        return inEdges;
    }

    public boolean pushNodeUp() {
        Collection inEdges = this.getInEdges();
        Iterator iter = inEdges.iterator();
        int minParentRank = Integer.MAX_VALUE;
        if (this.rank == -1 || inEdges.size() == 0) {
            return false;
        }
        boolean hasSetNewRank = false;
        while (iter.hasNext()) {
            LEdge edge = (LEdge)iter.next();
            SgymNode parent = (SgymNode)edge.getOtherEnd(this);
            if (parent.rank >= minParentRank) continue;
            minParentRank = parent.rank;
        }
        if (minParentRank - 1 > this.rank) {
            hasSetNewRank = true;
            this.rank = minParentRank - 1;
        }
        return hasSetNewRank;
    }
}

