/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.ivis.layout.Cluster;
import org.ivis.layout.ClusterManager;
import org.ivis.layout.Clustered;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.Layout;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;
import org.ivis.util.Transform;

public class LNode
extends LGraphObject
implements Clustered {
    protected LGraphManager graphManager;
    protected LGraph child;
    protected LGraph owner;
    protected List edges;
    protected RectangleD rect;
    protected List<Cluster> clusters;
    private int estimatedSize = Integer.MIN_VALUE;
    protected int inclusionTreeDepth = Integer.MAX_VALUE;
    private static Random random = new Random(1L);

    protected LNode(LGraphManager gm, Object vNode) {
        super(vNode);
        this.initialize();
        this.graphManager = gm;
        this.rect = new RectangleD();
    }

    protected LNode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(vNode);
        this.initialize();
        this.graphManager = gm;
        this.rect = new RectangleD(loc.x, loc.y, size.width, size.height);
    }

    protected LNode(Layout layout, Object vNode) {
        super(vNode);
        this.initialize();
        this.graphManager = layout.graphManager;
        this.rect = new RectangleD();
    }

    public void initialize() {
        this.edges = new LinkedList();
        this.clusters = new LinkedList<Cluster>();
    }

    public List getEdges() {
        return this.edges;
    }

    public LGraph getChild() {
        return this.child;
    }

    public void setChild(LGraph child) {
        assert (child == null || child.getGraphManager() == this.graphManager) : "Child has different graph mgr!";
        this.child = child;
    }

    public LGraph getOwner() {
        assert (this.owner == null || this.owner.getNodes().contains(this));
        return this.owner;
    }

    public void setOwner(LGraph owner) {
        this.owner = owner;
    }

    public double getWidth() {
        return this.rect.width;
    }

    public void setWidth(double width) {
        this.rect.width = width;
    }

    public double getHeight() {
        return this.rect.height;
    }

    public void setHeight(double height) {
        this.rect.height = height;
    }

    @Override
    public double getLeft() {
        return this.rect.x;
    }

    @Override
    public double getRight() {
        return this.rect.x + this.rect.width;
    }

    @Override
    public double getTop() {
        return this.rect.y;
    }

    @Override
    public double getBottom() {
        return this.rect.y + this.rect.height;
    }

    public double getCenterX() {
        return this.rect.x + this.rect.width / 2.0;
    }

    public double getCenterY() {
        return this.rect.y + this.rect.height / 2.0;
    }

    public PointD getCenter() {
        return new PointD(this.rect.x + this.rect.width / 2.0, this.rect.y + this.rect.height / 2.0);
    }

    public PointD getLocation() {
        return new PointD(this.rect.x, this.rect.y);
    }

    public RectangleD getRect() {
        return this.rect;
    }

    public double getDiagonal() {
        return Math.sqrt(this.rect.width * this.rect.width + this.rect.height * this.rect.height);
    }

    public double getHalfTheDiagonal() {
        return Math.sqrt(this.rect.height * this.rect.height + this.rect.width * this.rect.width) / 2.0;
    }

    public void setRect(Point upperLeft, Dimension dimension) {
        this.rect.x = upperLeft.x;
        this.rect.y = upperLeft.y;
        this.rect.width = dimension.width;
        this.rect.height = dimension.height;
    }

    public void setCenter(double cx, double cy) {
        this.rect.x = cx - this.rect.width / 2.0;
        this.rect.y = cy - this.rect.height / 2.0;
    }

    public void setLocation(double x, double y) {
        this.rect.x = x;
        this.rect.y = y;
    }

    public void moveBy(double dx, double dy) {
        this.rect.x += dx;
        this.rect.y += dy;
    }

    public String getClusterID() {
        if (this.clusters.isEmpty()) {
            return null;
        }
        return new Integer(this.clusters.get((int)0).clusterID).toString();
    }

    public List getClusters() {
        return this.clusters;
    }

    public List getEdgeListToNode(LNode to) {
        ArrayList<LEdge> edgeList = new ArrayList<LEdge>();
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            if (edge.target != to) continue;
            assert (edge.source == this) : "Incorrect edge source!";
            edgeList.add(edge);
        }
        return edgeList;
    }

    public List getEdgesBetween(LNode other) {
        ArrayList<LEdge> edgeList = new ArrayList<LEdge>();
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            assert (edge.source == this || edge.target == this) : "Incorrect edge source and/or target";
            if (edge.target != other && edge.source != other) continue;
            edgeList.add(edge);
        }
        return edgeList;
    }

    public boolean isNeighbor(LNode node) {
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            if (edge.source != node && edge.target != node) continue;
            return true;
        }
        return false;
    }

    public Set getNeighborsList() {
        HashSet<LNode> neighbors = new HashSet<LNode>();
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            if (edge.source.equals(this)) {
                neighbors.add(edge.target);
                continue;
            }
            assert (edge.target.equals(this)) : "Incorrect incidency!";
            neighbors.add(edge.source);
        }
        return neighbors;
    }

    public Set getSuccessors() {
        HashSet<LNode> neighbors = new HashSet<LNode>();
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            assert (edge.source.equals(this) || edge.target.equals(this)) : "Incorrect incidency!";
            if (!edge.source.equals(this)) continue;
            neighbors.add(edge.target);
        }
        return neighbors;
    }

    public List withChildren() {
        LinkedList<LNode> withNeighborsList = new LinkedList<LNode>();
        withNeighborsList.add(this);
        if (this.child != null) {
            for (Object childObject : this.child.getNodes()) {
                LNode childNode = (LNode)childObject;
                withNeighborsList.addAll(childNode.withChildren());
            }
        }
        return withNeighborsList;
    }

    public int getEstimatedSize() {
        assert (this.estimatedSize != Integer.MIN_VALUE);
        return this.estimatedSize;
    }

    public int calcEstimatedSize() {
        if (this.child == null) {
            this.estimatedSize = (int)((this.rect.width + this.rect.height) / 2.0);
            return this.estimatedSize;
        }
        this.estimatedSize = this.child.calcEstimatedSize();
        this.rect.width = this.estimatedSize;
        this.rect.height = this.estimatedSize;
        return this.estimatedSize;
    }

    protected void scatter() {
        double minX = -1000.0;
        double maxX = 1000.0;
        double randomCenterX = 1200.0 + random.nextDouble() * (maxX - minX) + minX;
        double minY = -1000.0;
        double maxY = 1000.0;
        double randomCenterY = 900.0 + random.nextDouble() * (maxY - minY) + minY;
        this.rect.x = randomCenterX;
        this.rect.y = randomCenterY;
    }

    public void updateBounds() {
        assert (this.getChild() != null);
        if (this.getChild().getNodes().size() != 0) {
            LGraph childGraph = this.getChild();
            childGraph.updateBounds(true);
            this.rect.x = childGraph.getLeft();
            this.rect.y = childGraph.getTop();
            this.setWidth(childGraph.getRight() - childGraph.getLeft() + 10);
            this.setHeight(childGraph.getBottom() - childGraph.getTop() + 10 + 20);
        }
    }

    public int getInclusionTreeDepth() {
        assert (this.inclusionTreeDepth != Integer.MAX_VALUE);
        return this.inclusionTreeDepth;
    }

    public Vector getAllParents() {
        Vector<LNode> parents = new Vector<LNode>();
        LNode rootNode = this.owner.getGraphManager().getRoot().getParent();
        LNode parent = this.owner.getParent();
        while (parent != rootNode) {
            parents.add(parent);
            parent = parent.getOwner().getParent();
        }
        parents.add(rootNode);
        return parents;
    }

    public void transform(Transform trans) {
        double left = this.rect.x;
        if (left > 1000000.0) {
            left = 1000000.0;
        } else if (left < -1000000.0) {
            left = -1000000.0;
        }
        double top = this.rect.y;
        if (top > 1000000.0) {
            top = 1000000.0;
        } else if (top < -1000000.0) {
            top = -1000000.0;
        }
        PointD leftTop = new PointD(left, top);
        PointD vLeftTop = trans.inverseTransformPoint(leftTop);
        this.setLocation(vLeftTop.x, vLeftTop.y);
    }

    @Override
    public void addCluster(int clusterID) {
        ClusterManager cm = this.graphManager.getClusterManager();
        Cluster cluster = cm.getClusterByID(clusterID);
        if (cluster == null) {
            cluster = new Cluster(cm, clusterID, "Cluster " + clusterID);
            cm.addCluster(cluster);
        }
        this.addCluster(cluster);
    }

    @Override
    public void addCluster(Cluster cluster) {
        if (cluster == null) {
            return;
        }
        if (!this.clusters.contains(cluster)) {
            this.clusters.add(cluster);
            cluster.getNodes().add(this);
            if (this.child != null) {
                List childrenNodes = this.child.getNodes();
                for (LNode childNode : childrenNodes) {
                    childNode.addCluster(cluster);
                }
            }
        }
    }

    @Override
    public void removeCluster(Cluster cluster) {
        if (cluster == null) {
            return;
        }
        if (this.clusters.contains(cluster)) {
            this.clusters.remove(cluster);
            cluster.getNodes().remove(this);
            if (this.child != null) {
                List childrenNodes = this.child.getNodes();
                for (LNode childNode : childrenNodes) {
                    childNode.removeCluster(cluster);
                }
            }
        }
    }

    @Override
    public void resetClusters() {
        for (Cluster cluster : this.clusters) {
            cluster.getNodes().remove(this);
        }
        this.clusters.clear();
    }

    @Override
    public Clustered getParent() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getParent();
    }

    public boolean belongsToCluster(Cluster cluster) {
        return this.clusters.contains(cluster);
    }

    public void printTopology() {
        System.out.print(this.label == null ? "?" : this.label + "{");
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            LNode otherEnd = edge.getOtherEnd(this);
            System.out.print(otherEnd.label == null ? "?" : otherEnd.label + ",");
        }
        System.out.print("} ");
    }
}

