/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.io.xml;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.ivis.io.xml.model.EdgeComplexType;
import org.ivis.io.xml.model.GraphObjectComplexType;
import org.ivis.io.xml.model.NodeComplexType;
import org.ivis.io.xml.model.ObjectFactory;
import org.ivis.io.xml.model.View;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDLayout;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class XmlIOHandler {
    private Layout layout;
    private LGraphManager gm;
    private LGraph rootGraph;
    private HashMap<GraphObjectComplexType, LGraphObject> xmlObjectToLayoutObject = new HashMap();
    private HashMap<String, GraphObjectComplexType> xmlIDToXMLObject = new HashMap();
    private JAXBContext jaxbContext = JAXBContext.newInstance("org.ivis.io.xml.model");
    private ObjectFactory objectFactory = new ObjectFactory();
    private View loadedModel;

    public XmlIOHandler(Layout layout) throws JAXBException {
        this.layout = layout;
        this.gm = this.layout.getGraphManager();
        this.rootGraph = this.gm.addRoot();
    }

    public void fromXML(InputStream inputStream) throws JAXBException, OperationNotSupportedException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        this.loadedModel = (View)unmarshaller.unmarshal(inputStream);
        for (NodeComplexType nodeType : this.loadedModel.getNode()) {
            this.parseNode(nodeType, null);
        }
        for (EdgeComplexType edgeType : this.loadedModel.getEdge()) {
            this.parseEdge(edgeType);
        }
    }

    public void toXML(OutputStream outputStream) throws JAXBException, OperationNotSupportedException, IOException {
        if (this.loadedModel == null) {
            throw new OperationNotSupportedException("There is no previouslyloaded xml file. Please first laod an xml file first.");
        }
        for (GraphObjectComplexType xmlObject : this.xmlObjectToLayoutObject.keySet()) {
            LGraphObject lGraphObject = this.xmlObjectToLayoutObject.get(xmlObject);
            if (lGraphObject instanceof LNode) {
                this.writeNodeBack((LNode)lGraphObject, (NodeComplexType)xmlObject);
                continue;
            }
            if (!(lGraphObject instanceof LEdge)) continue;
            this.writeEdgeBack((LEdge)lGraphObject, (EdgeComplexType)xmlObject);
        }
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new EmptyNameSpacePrefixMapper());
        this.writePortAndProcessNodes();
        marshaller.marshal((Object)this.loadedModel, outputStream);
    }

    private void parseNode(NodeComplexType xmlNode, NodeComplexType parentXmlNode) throws OperationNotSupportedException {
        LNode lNode = this.layout.newNode(null);
        this.xmlObjectToLayoutObject.put(xmlNode, lNode);
        this.setIdIndex(xmlNode);
        if (parentXmlNode != null) {
            LNode parentLNode = (LNode)this.xmlObjectToLayoutObject.get(parentXmlNode);
            assert (parentLNode.getChild() != null) : "Parent node doesn't have child graph.";
            parentLNode.getChild().add(lNode);
        } else {
            this.rootGraph.add(lNode);
        }
        NodeComplexType.Bounds bounds = xmlNode.getBounds();
        lNode.setLocation(bounds.getX(), bounds.getY());
        lNode.setWidth(bounds.getWidth());
        lNode.setHeight(bounds.getHeight());
        lNode.type = xmlNode.getType().getValue();
        lNode.label = xmlNode.getId();
        if (xmlNode.getClusterIDs() != null) {
            for (String id : xmlNode.getClusterIDs().getClusterID()) {
                lNode.addCluster(Integer.parseInt(id));
            }
        }
        if (xmlNode.getChildren() != null) {
            LGraph childGraph = this.gm.add(this.layout.newGraph(null), lNode);
            for (NodeComplexType childNode : xmlNode.getChildren().getNode()) {
                this.parseNode(childNode, xmlNode);
            }
        }
    }

    private void parseEdge(EdgeComplexType xmlEdge) throws OperationNotSupportedException {
        LEdge lEdge = this.layout.newEdge(null);
        lEdge.type = xmlEdge.getType().getValue();
        lEdge.label = xmlEdge.getId();
        String sourceXmlNodeId = xmlEdge.getSourceNode().getId();
        String targetXmlNodeId = xmlEdge.getTargetNode().getId();
        LNode sourceLNode = (LNode)this.xmlObjectToLayoutObject.get(this.xmlIDToXMLObject.get(sourceXmlNodeId));
        LNode targetLNode = (LNode)this.xmlObjectToLayoutObject.get(this.xmlIDToXMLObject.get(targetXmlNodeId));
        if (sourceLNode == null) {
            throw new OperationNotSupportedException("Source node with the given ID <" + sourceXmlNodeId + "> does not exist for edge " + "with ID <" + xmlEdge.getId() + ">");
        }
        if (targetLNode == null) {
            throw new OperationNotSupportedException("Source node with the given ID <" + targetXmlNodeId + "> does not exist for edge " + "with ID <" + xmlEdge.getId() + ">");
        }
        this.gm.add(lEdge, sourceLNode, targetLNode);
        this.xmlObjectToLayoutObject.put(xmlEdge, lEdge);
        if (xmlEdge.getBendPointList() != null) {
            for (EdgeComplexType.BendPointList.BendPoint xmlBendPoint : xmlEdge.getBendPointList().getBendPoint()) {
                PointD bendPoint = new PointD(xmlBendPoint.getX(), xmlBendPoint.getY());
                lEdge.getBendpoints().add(bendPoint);
            }
        }
    }

    private void writeNodeBack(LNode lNode, NodeComplexType xmlNode) {
        RectangleD nodeBounds = lNode.getRect();
        xmlNode.getBounds().setHeight((int)nodeBounds.height);
        xmlNode.getBounds().setWidth((int)nodeBounds.width);
        xmlNode.getBounds().setX((int)nodeBounds.x);
        xmlNode.getBounds().setY((int)nodeBounds.y);
    }

    private void writeEdgeBack(LEdge lEdge, EdgeComplexType xmlEdge) {
        List<PointD> bendPoints = lEdge.getBendpoints();
        EdgeComplexType.BendPointList xmlBendPoints = xmlEdge.getBendPointList();
        if (xmlBendPoints == null) {
            xmlEdge.setBendPointList(this.objectFactory.createEdgeComplexTypeBendPointList());
        } else {
            xmlBendPoints.getBendPoint().clear();
        }
        for (PointD pointD : bendPoints) {
            EdgeComplexType.BendPointList.BendPoint xmlBendPoint = this.objectFactory.createEdgeComplexTypeBendPointListBendPoint();
            xmlBendPoint.setX(pointD.x);
            xmlBendPoint.setY(pointD.y);
            xmlBendPoints.getBendPoint().add(xmlBendPoint);
        }
    }

    private void setIdIndex(GraphObjectComplexType xmlGraphObject) throws OperationNotSupportedException {
        String id = xmlGraphObject.getId();
        if (this.xmlIDToXMLObject.get(id) != null) {
            throw new OperationNotSupportedException("The ID:" + id + " is used" + " more than one time");
        }
        this.xmlIDToXMLObject.put(id, xmlGraphObject);
    }

    public static void main(String[] args) throws Exception {
        SbgnPDLayout layout = new SbgnPDLayout();
        XmlIOHandler handler = new XmlIOHandler(layout);
        handler.fromXML(new FileInputStream("src/main/java/org/ivis/io/xml/layout.xml"));
        layout.runLayout();
        handler.toXML(new FileOutputStream("src/main/java/org/ivis/io/xml/layout_done.xml"));
    }

    private void writePortAndProcessNodes() {
        for (Object o : this.gm.getAllNodes()) {
            if (!(o instanceof SbgnProcessNode) && (!(o instanceof SbgnPDNode) || ((SbgnPDNode)o).type == null || !((SbgnPDNode)o).type.equals("input_port") && !((SbgnPDNode)o).type.equals("output_port"))) continue;
            SbgnPDNode s = (SbgnPDNode)o;
            NodeComplexType.Bounds b = new NodeComplexType.Bounds();
            b.setHeight((int)s.getHeight());
            b.setWidth((int)s.getWidth());
            b.setX((int)s.getLeft());
            b.setY((int)s.getTop());
            NodeComplexType.Type t = new NodeComplexType.Type();
            t.setValue(s.type);
            NodeComplexType n = this.objectFactory.createNodeComplexType();
            n.setBounds(b);
            n.setType(t);
            n.setChildren(null);
            n.setId(s.label);
            this.loadedModel.addNode(n);
            this.xmlObjectToLayoutObject.put(n, null);
        }
    }

    private void writeRigidEdges() {
        for (Object o : this.gm.getAllEdges()) {
            if (!(o instanceof SbgnPDEdge)) continue;
            SbgnPDEdge r = (SbgnPDEdge)o;
            if (!r.type.equals("rigid edge")) continue;
            EdgeComplexType e2 = this.objectFactory.createEdgeComplexType();
            EdgeComplexType.SourceNode s = new EdgeComplexType.SourceNode();
            s.setId(r.getSource().label);
            EdgeComplexType.TargetNode t = new EdgeComplexType.TargetNode();
            t.setId(r.getTarget().label);
            EdgeComplexType.Type et = new EdgeComplexType.Type();
            et.setValue(r.type);
            e2.setType(et);
            e2.setSourceNode(s);
            e2.setTargetNode(t);
            e2.setBendPointList(new EdgeComplexType.BendPointList());
            e2.setId(r.label);
            this.loadedModel.addEdge(e2);
        }
    }

    public Layout test(String fileName) throws Exception {
        XmlIOHandler handler = new XmlIOHandler(this.layout);
        handler.fromXML(new FileInputStream(fileName));
        this.layout.runLayout();
        return this.layout;
    }

    private static void generateClasses() throws Exception {
        String s = null;
        String execName = "C:\\Program Files\\Java\\jdk1.7.0_40\\bin\\xjc.exe";
        String deneme = execName + " -p org.ivis.io.xml.model " + "src/main/java/org/ivis/io/xml/layout.xsd -d src";
        Process p = Runtime.getRuntime().exec(deneme);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
        }
        BufferedReader errInput = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((s = errInput.readLine()) != null) {
            System.out.println(s);
        }
    }

    private class EmptyNameSpacePrefixMapper
    extends NamespacePrefixMapper {
        private EmptyNameSpacePrefixMapper() {
        }

        @Override
        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if (namespaceUri.equals("")) {
                return null;
            }
            return "xsi";
        }
    }
}

