/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.Node;

public abstract class AbstractNode
implements Node {
    protected Graph graph;
    protected boolean upstreamInited;
    protected boolean downstreamInited;
    protected Set<Node> upperEquivalent;
    protected Set<Node> lowerEquivalent;
    protected Set<Edge> upstream;
    protected Set<Edge> downstream;
    protected int pathSign;
    protected Set<Node> banned;

    protected AbstractNode(Graph graph) {
        this.graph = graph;
        this.upstream = new HashSet<Edge>();
        this.downstream = new HashSet<Edge>();
        this.upstreamInited = false;
        this.downstreamInited = false;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public Set<Node> getBanned() {
        if (this.banned == null) {
            return Collections.emptySet();
        }
        return this.banned;
    }

    public void initBanned() {
        if (this.banned == null) {
            this.banned = new HashSet<Node>();
        }
    }

    public void setBanned(Set<Node> banned) {
        this.banned = banned;
    }

    @Override
    public Collection<Edge> getUpstream() {
        if (!this.upstreamInited) {
            this.initUpstream();
            this.upstreamInited = true;
        }
        return this.upstream;
    }

    @Override
    public Collection<Edge> getDownstream() {
        if (!this.downstreamInited) {
            this.initDownstream();
            this.downstreamInited = true;
        }
        return this.downstream;
    }

    public void initUpstream() {
    }

    public void initDownstream() {
    }

    public Collection<Edge> getUpstreamNoInit() {
        return this.upstream;
    }

    public Collection<Edge> getDownstreamNoInit() {
        return this.downstream;
    }

    @Override
    public Collection<Node> getUpperEquivalent() {
        return this.upperEquivalent;
    }

    @Override
    public Collection<Node> getLowerEquivalent() {
        return this.lowerEquivalent;
    }

    @Override
    public void init() {
    }

    public int getPathSign() {
        return this.pathSign;
    }

    public void setPathSign(int pathSign) {
        this.pathSign = pathSign;
    }

    @Override
    public void clear() {
        this.pathSign = 0;
    }

    @Override
    public boolean isTranscription() {
        return false;
    }
}

