/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.model;

import java.util.HashMap;
import java.util.Map;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public abstract class AbstractGraph
implements Graph {
    protected Map<String, GraphObject> objectMap = new HashMap<String, GraphObject>();

    protected AbstractGraph() {
    }

    @Override
    public GraphObject getGraphObject(Object obj) {
        Node node;
        String key = this.getKey(obj);
        GraphObject go = this.objectMap.get(key);
        if (go == null && (node = this.wrap(obj)) != null) {
            this.objectMap.put(key, node);
            node.init();
        }
        return this.objectMap.get(key);
    }

    public GraphObject getGraphObject(String id) {
        return this.objectMap.get(id);
    }

    public Map<String, GraphObject> getObjectMap() {
        return this.objectMap;
    }

    @Override
    public void clear() {
        for (GraphObject go : this.objectMap.values()) {
            go.clear();
        }
    }

    public abstract String getKey(Object var1);

    public abstract Node wrap(Object var1);
}

