/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;

public class DifferentialModificationUtil {
    public static Set<ModificationFeature>[] getChangedModifications(PhysicalEntity before, PhysicalEntity after) {
        Set<Modification> set1 = DifferentialModificationUtil.collectFeatures(before);
        Set<Modification> set2 = DifferentialModificationUtil.collectFeatures(after);
        HashSet<Modification> temp = new HashSet<Modification>(set1);
        set1.removeAll(set2);
        set2.removeAll(temp);
        return new Set[]{DifferentialModificationUtil.collectFeatures(set2), DifferentialModificationUtil.collectFeatures(set1)};
    }

    public static Set<String> collectChangedPhosphorylationSites(PhysicalEntity before, PhysicalEntity after, boolean gained) {
        Set<ModificationFeature> set = DifferentialModificationUtil.getChangedModifications(before, after)[gained ? 0 : 1];
        HashSet<String> sites = new HashSet<String>();
        for (ModificationFeature mf : set) {
            int site;
            String lett = DifferentialModificationUtil.getPhosphoSiteLetter(mf);
            if (lett == null || (site = DifferentialModificationUtil.getPhosphoSite(mf)) <= 0) continue;
            sites.add(lett + site);
        }
        return sites;
    }

    private static Set<Modification> collectFeatures(PhysicalEntity pe) {
        HashSet<Modification> set = new HashSet<Modification>();
        for (EntityFeature f : pe.getFeature()) {
            if (!(f instanceof ModificationFeature)) continue;
            set.add(new Modification((ModificationFeature)f));
        }
        return set;
    }

    private static Set<ModificationFeature> collectFeatures(Set<Modification> wrappers) {
        if (wrappers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ModificationFeature> set = new HashSet<ModificationFeature>();
        for (Modification wrapper : wrappers) {
            set.add(wrapper.mf);
        }
        return set;
    }

    private static String getPhosphoSiteLetter(ModificationFeature mf) {
        if (mf.getModificationType() != null) {
            for (String term : mf.getModificationType().getTerm()) {
                if (!(term = term.toLowerCase()).contains("phospho")) continue;
                if (term.contains("serine")) {
                    return "S";
                }
                if (term.contains("threonine")) {
                    return "T";
                }
                if (!term.contains("tyrosine")) continue;
                return "Y";
            }
        }
        return null;
    }

    private static int getPhosphoSite(ModificationFeature mf) {
        SequenceLocation loc = mf.getFeatureLocation();
        if (loc != null && loc instanceof SequenceSite) {
            return ((SequenceSite)loc).getSequencePosition();
        }
        return -1;
    }

    private static class Modification {
        ModificationFeature mf;

        Modification(ModificationFeature mf) {
            this.mf = mf;
        }

        public int hashCode() {
            SequenceLocation loc;
            int code = 0;
            SequenceModificationVocabulary type = this.mf.getModificationType();
            if (type != null) {
                for (String term : type.getTerm()) {
                    code += term.hashCode();
                }
            }
            if ((loc = this.mf.getFeatureLocation()) != null) {
                if (loc instanceof SequenceInterval) {
                    SequenceSite begin = ((SequenceInterval)loc).getSequenceIntervalBegin();
                    SequenceSite end = ((SequenceInterval)loc).getSequenceIntervalEnd();
                    if (begin != null) {
                        code += begin.getSequencePosition();
                    }
                    if (end != null) {
                        code += end.getSequencePosition();
                    }
                } else if (loc instanceof SequenceSite) {
                    code += ((SequenceSite)loc).getSequencePosition();
                }
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Modification)) {
                return false;
            }
            Modification m = (Modification)obj;
            if (this.mf == m.mf) {
                return true;
            }
            if (this.mf.getModificationType() == null || m.mf.getModificationType() == null) {
                return false;
            }
            if (!this.mf.getModificationType().getTerm().containsAll(m.mf.getModificationType().getTerm())) {
                return false;
            }
            if (this.mf.getFeatureLocation() == null && m.mf.getFeatureLocation() == null) {
                return true;
            }
            if (this.mf.getFeatureLocation() == null || m.mf.getFeatureLocation() == null) {
                return false;
            }
            return this.mf.getFeatureLocation().equivalenceCode() == m.mf.getFeatureLocation().equivalenceCode();
        }
    }
}

