/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.pattern.Pattern;

public class Match
implements Cloneable {
    private BioPAXElement[] variables;

    public Match(int size) {
        this.variables = new BioPAXElement[size];
    }

    public BioPAXElement[] getVariables() {
        return this.variables;
    }

    public BioPAXElement get(int index) {
        return this.variables[index];
    }

    public BioPAXElement get(String label, Pattern p) {
        return this.variables[p.indexOf(label)];
    }

    public List<BioPAXElement> get(String[] label, Pattern p) {
        if (label == null) {
            return Collections.emptyList();
        }
        ArrayList<BioPAXElement> list = new ArrayList<BioPAXElement>(label.length);
        for (String lab : label) {
            list.add(this.variables[p.indexOf(lab)]);
        }
        return list;
    }

    public BioPAXElement getFirst() {
        return this.variables[0];
    }

    public BioPAXElement getLast() {
        return this.variables[this.variables.length - 1];
    }

    public int varSize() {
        return this.variables.length;
    }

    public void set(BioPAXElement ele, int index) {
        this.variables[index] = ele;
    }

    public boolean varsPresent(int ... ind) {
        for (int i : ind) {
            if (this.variables[i] != null) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        Match m = null;
        try {
            m = (Match)super.clone();
            m.variables = new BioPAXElement[this.variables.length];
            System.arraycopy(this.variables, 0, m.variables, 0, this.variables.length);
            return m;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("super.clone() not supported.");
        }
    }

    public String toString() {
        String s = "";
        int i = 0;
        for (BioPAXElement ele : this.variables) {
            if (ele != null) {
                s = s + i + " - " + this.getAName(ele) + "\n";
            }
            ++i;
        }
        return s;
    }

    public String getAName(BioPAXElement ele) {
        String name = null;
        if (ele instanceof Named) {
            Named n = (Named)ele;
            if (n.getDisplayName() != null && n.getDisplayName().length() > 0) {
                name = n.getDisplayName();
            } else if (n.getStandardName() != null && n.getStandardName().length() > 0) {
                name = n.getStandardName();
            } else if (!n.getName().isEmpty() && n.getName().iterator().next().length() > 0) {
                name = n.getName().iterator().next();
            }
        }
        if (name == null) {
            name = ele.getRDFId();
        }
        return name + " (" + ele.getModelInterface().getName().substring(ele.getModelInterface().getName().lastIndexOf(".") + 1) + ")";
    }
}

