/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.SequenceLocationImpl;
import org.biopax.paxtools.impl.level3.SequenceSiteImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=SequenceInterval.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SequenceIntervalImpl
extends SequenceLocationImpl
implements SequenceInterval {
    private SequenceSite sequenceIntervalBegin;
    private SequenceSite sequenceIntervalEnd;

    @Transient
    public Class<? extends SequenceInterval> getModelInterface() {
        return SequenceInterval.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof SequenceInterval)) {
            return false;
        }
        SequenceInterval that = (SequenceInterval)element;
        return this.sequenceIntervalBegin != null && this.sequenceIntervalBegin.isEquivalent(that.getSequenceIntervalBegin()) && this.sequenceIntervalEnd != null && this.sequenceIntervalEnd.isEquivalent(that.getSequenceIntervalEnd());
    }

    @Override
    public int equivalenceCode() {
        int result = 29 + (this.sequenceIntervalBegin != null ? this.sequenceIntervalBegin.equivalenceCode() : 0);
        result = 29 * result + (this.sequenceIntervalEnd != null ? this.sequenceIntervalEnd.equivalenceCode() : 0);
        return result;
    }

    @Override
    @ManyToOne(targetEntity=SequenceSiteImpl.class)
    public SequenceSite getSequenceIntervalBegin() {
        return this.sequenceIntervalBegin;
    }

    @Override
    public void setSequenceIntervalBegin(SequenceSite sequenceIntervalBegin) {
        this.sequenceIntervalBegin = sequenceIntervalBegin;
    }

    @Override
    @ManyToOne(targetEntity=SequenceSiteImpl.class)
    public SequenceSite getSequenceIntervalEnd() {
        return this.sequenceIntervalEnd;
    }

    @Override
    public void setSequenceIntervalEnd(SequenceSite sequenceIntervalEnd) {
        this.sequenceIntervalEnd = sequenceIntervalEnd;
    }

    @Override
    public String toString() {
        return this.getSequenceIntervalBegin() + "-" + this.getSequenceIntervalEnd();
    }
}

