/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.StoichiometryImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Complex.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ComplexImpl
extends PhysicalEntityImpl
implements Complex {
    private Set<PhysicalEntity> component = BPCollections.I.createSafeSet();
    private Set<Stoichiometry> componentStoichiometry = BPCollections.I.createSafeSet();

    @Transient
    public Class<? extends Complex> getModelInterface() {
        return Complex.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="component")
    public Set<PhysicalEntity> getComponent() {
        return this.component;
    }

    @Override
    public void addComponent(PhysicalEntity component) {
        if (component != null) {
            this.component.add(component);
            component.getComponentOf().add(this);
        }
    }

    @Override
    public void removeComponent(PhysicalEntity component) {
        if (component != null) {
            this.component.remove(component);
            component.getComponentOf().remove(this);
        }
    }

    protected void setComponent(Set<PhysicalEntity> component) {
        this.component = component;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=StoichiometryImpl.class)
    @JoinTable(name="complexstoichiometry")
    public Set<Stoichiometry> getComponentStoichiometry() {
        return this.componentStoichiometry;
    }

    @Override
    public void addComponentStoichiometry(Stoichiometry stoichiometry) {
        if (stoichiometry != null) {
            this.componentStoichiometry.add(stoichiometry);
        }
    }

    @Override
    public void removeComponentStoichiometry(Stoichiometry stoichiometry) {
        if (stoichiometry != null) {
            this.componentStoichiometry.remove(stoichiometry);
        }
    }

    protected void setComponentStoichiometry(Set<Stoichiometry> stoichiometry) {
        this.componentStoichiometry = stoichiometry;
    }

    @Override
    @Transient
    public Set<SimplePhysicalEntity> getSimpleMembers() {
        return this.getSimpleMembers(BPCollections.I.createSet());
    }

    @Transient
    protected Set<SimplePhysicalEntity> getSimpleMembers(Set<SimplePhysicalEntity> set) {
        for (PhysicalEntity pe : this.getComponent()) {
            this.collectSimpleMembersRecursive(pe, set);
        }
        return set;
    }

    protected void collectSimpleMembersRecursive(PhysicalEntity pe, Set<SimplePhysicalEntity> set) {
        if (pe instanceof ComplexImpl && pe != this) {
            ((ComplexImpl)pe).collectSimpleMembersRecursive(pe, set);
        } else if (pe instanceof SimplePhysicalEntity) {
            set.add((SimplePhysicalEntity)pe);
        }
        for (PhysicalEntity mem : pe.getMemberPhysicalEntity()) {
            this.collectSimpleMembersRecursive(mem, set);
        }
    }

    @Override
    @Transient
    public Set<EntityReference> getMemberReferences() {
        Set<EntityReference> set = BPCollections.I.createSet();
        for (SimplePhysicalEntity spe : this.getSimpleMembers()) {
            EntityReference er = spe.getEntityReference();
            if (er == null) continue;
            set.add(er);
        }
        return set;
    }

    @Transient
    public Class<? extends PhysicalEntity> getPhysicalEntityClass() {
        return Complex.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof Complex)) {
            return false;
        }
        return SetEquivalenceChecker.isEquivalent(this.getComponent(), ((Complex)element).getComponent()) && super.semanticallyEquivalent(element);
    }
}

