/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.util.Filter;

public class Tutorial {
    public static void myFirstModel() {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Model model = factory.createModel();
        Protein protein1 = model.addNew(Protein.class, "http://biopax.org/tutorial/test1");
        protein1.addName("Tutorial Example Small molecule Transporter 1");
        protein1.setDisplayName("TEST1");
        BiochemicalReaction rxn1 = model.addNew(BiochemicalReaction.class, "http://biopax.org/tutorial/rxn1");
        rxn1.addLeft(protein1);
    }

    public static void IO(InputStream inputStreamFromFile, OutputStream outputStream) {
        SimpleIOHandler handler = new SimpleIOHandler();
        Model model = handler.convertFromOWL(inputStreamFromFile);
        handler.convertToOWL(model, outputStream);
        Object id1 = null;
        Object id2 = null;
        Object id3 = null;
        handler.convertToOWL(model, outputStream, id1, id2, id3);
    }

    public static void tempted(BioPAXIOHandler handler, InputStream inputStream, OutputStream outputStream) {
        Model model1 = handler.convertFromOWL(inputStream);
        Model model2 = model1.getLevel().getDefaultFactory().createModel();
        model2.add(model1.getByID("The_reaction_id"));
        handler.convertToOWL(model2, outputStream);
    }

    public static void merge(EditorMap editorMap, Model srcModel2, Model srcModel1) {
        Model targetModel = editorMap.getLevel().getDefaultFactory().createModel();
        Merger merger = new Merger(editorMap);
        merger.merge(targetModel, srcModel1, srcModel2);
    }

    public Set access1(Complex complex2) {
        HashSet<UnificationXref> xrefs = new HashSet<UnificationXref>();
        this.recursivelyObtainMembers(complex2, xrefs);
        return xrefs;
    }

    private void recursivelyObtainMembers(Complex complex2, Set<UnificationXref> xrefs) {
        for (PhysicalEntity pe : complex2.getComponent()) {
            if (pe instanceof Complex) {
                this.recursivelyObtainMembers((Complex)pe, xrefs);
                continue;
            }
            Set<Xref> memberxrefs = ((SimplePhysicalEntity)pe).getEntityReference().getXref();
            for (Xref xref2 : memberxrefs) {
                if (!(xref2 instanceof UnificationXref)) continue;
                xrefs.add((UnificationXref)xref2);
            }
        }
    }

    public Set access2(Complex complex2) {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        PathAccessor pathAccessor = new PathAccessor("ProteinReference/xref:UnificationXref", BioPAXLevel.L3);
        for (Protein currentProtein : model.getObjects(Protein.class)) {
            Set unificationXrefs = pathAccessor.getValueFromBean(currentProtein);
            for (Xref currentRef : unificationXrefs) {
                System.out.println("Unification XRef:  " + currentRef.getDb() + ": " + currentRef.getId());
            }
        }
        PathAccessor accessor = new PathAccessor("Complex/component*/EntityReference/xref:UnificationXref", BioPAXLevel.L3);
        return new PathAccessor("Complex/component*/EntityReference/xref:UnificationXref", BioPAXLevel.L3).getValueFromBean(complex2);
    }

    public void graphQuery(Model model, PhysicalEntity entity3, PhysicalEntity entity2, PhysicalEntity entity1) {
        HashSet<BioPAXElement> sourceSet = new HashSet<BioPAXElement>();
        Collections.addAll(sourceSet, entity1, entity2, entity3);
        int limit = 2;
        Direction direction = Direction.BOTHSTREAM;
        Set<BioPAXElement> result = QueryExecuter.runNeighborhood(sourceSet, model, limit, direction, null);
        Completer c = new Completer(SimpleEditorMap.get(BioPAXLevel.L3));
        result = c.complete(result, model);
    }

    public void simpleTraverse() throws FileNotFoundException {
        FileInputStream fin = new FileInputStream("test_data/dna_repair.owl");
        SimpleIOHandler handler = new SimpleIOHandler();
        Model model = handler.convertFromOWL(fin);
        Set<BioPAXElement> elementSet = model.getObjects();
        for (BioPAXElement currentElement : elementSet) {
            String rdfId = currentElement.getRDFId();
            String className = currentElement.getClass().getName();
            System.out.println("Element:  " + rdfId + ": " + className);
        }
        Set<Protein> proteinSet = model.getObjects(Protein.class);
        for (Protein currentProtein : proteinSet) {
            System.out.println("Protein:  " + currentProtein.getName() + ": " + currentProtein.getDisplayName());
        }
        proteinSet = model.getObjects(Protein.class);
        for (Protein currentProtein : proteinSet) {
            EntityReference entityReference = currentProtein.getEntityReference();
            if (entityReference == null) continue;
            Set<Xref> xrefSet = entityReference.getXref();
            for (Xref currentRef : xrefSet) {
                if (!(currentRef instanceof UnificationXref)) continue;
                System.out.println("Unification XRef:  " + currentRef.getDb() + ": " + currentRef.getId());
            }
        }
    }

    public void highlightWorkaround() {
        Tutorial.myFirstModel();
        Tutorial.IO(null, null);
        Excisor ex = new Excisor(null);
        this.access1(null);
        this.graphQuery(null, null, null, null);
    }

    class Excisor
    implements Visitor {
        private Traverser traverser;
        private EditorMap editorMap;
        private Model targetModel;

        public Excisor(EditorMap editorMap) {
            this.editorMap = editorMap;
            this.traverser = new Traverser(editorMap, this, new Filter[0]);
        }

        public Excisor(EditorMap editorMap, boolean filtering) {
            this.editorMap = editorMap;
            if (filtering) {
                Filter<PropertyEditor> nextStepFilter = new Filter<PropertyEditor>(){

                    @Override
                    public boolean filter(PropertyEditor editor) {
                        return !editor.getProperty().equals("nextStep");
                    }
                };
                this.traverser = new Traverser(editorMap, this, nextStepFilter);
            } else {
                this.traverser = new Traverser(editorMap, this, new Filter[0]);
            }
        }

        public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
            BioPAXElement bpe;
            if (range != null && range instanceof BioPAXElement && !this.targetModel.contains(bpe = (BioPAXElement)range)) {
                this.targetModel.add(bpe);
                this.traverser.traverse(bpe, model);
            }
        }

        public Model excise(Model sourceModel, String ... ids) {
            this.targetModel = this.editorMap.getLevel().getDefaultFactory().createModel();
            for (String id : ids) {
                BioPAXElement bpe = sourceModel.getByID(id);
                this.targetModel.add(bpe);
                this.traverser.traverse(bpe, sourceModel);
            }
            return this.targetModel;
        }
    }
}

