/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.miner.OldFormatWriter;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;

public final class SifnxExportExample {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Please run again providing arguments: input(BioPAX OWL file), output");
            System.exit(-1);
        }
        SimpleIOHandler biopaxReader = new SimpleIOHandler();
        Model model = biopaxReader.convertFromOWL(new FileInputStream(args[0]));
        ModelUtils.mergeEquivalentInteractions(model);
        SIFSearcher searcher = new SIFSearcher(SIFEnum.values());
        Set<SIFInteraction> binaryInts = searcher.searchSIF(model);
        FileOutputStream out = new FileOutputStream(args[1]);
        OldFormatWriter.write(binaryInts, out);
        try {
            ((OutputStream)out).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

