/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Similarity;

public abstract class Scorer {
    private Similarity similarity;

    protected Scorer(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void score(HitCollector hc) throws IOException {
        while (this.next()) {
            hc.collect(this.doc(), this.score());
        }
    }

    protected boolean score(HitCollector hc, int max2) throws IOException {
        while (this.doc() < max2) {
            hc.collect(this.doc(), this.score());
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean next() throws IOException;

    public abstract int doc();

    public abstract float score() throws IOException;

    public abstract boolean skipTo(int var1) throws IOException;

    public abstract Explanation explain(int var1) throws IOException;
}

