/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.BoundedCollection;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.collection.PredicatedCollection;
import org.apache.commons.collections15.collection.SynchronizedCollection;
import org.apache.commons.collections15.collection.TransformedCollection;
import org.apache.commons.collections15.collection.TypedCollection;
import org.apache.commons.collections15.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections15.collection.UnmodifiableCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static Integer INTEGER_ONE = new Integer(1);
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static <E> Collection<E> union(Collection<? extends E> a, Collection<? extends E> b) {
        ArrayList list = new ArrayList();
        Map<? extends E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<? extends E, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        HashSet<? extends E> elts = new HashSet<E>(a);
        elts.addAll(b);
        for (Object e2 : elts) {
            int m = Math.max(CollectionUtils.getFreq(e2, mapa), CollectionUtils.getFreq(e2, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(e2);
            }
        }
        return list;
    }

    public static <E> Collection<E> intersection(Collection<? extends E> a, Collection<? extends E> b) {
        ArrayList list = new ArrayList();
        Map<? extends E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<? extends E, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        HashSet<? extends E> elts = new HashSet<E>(a);
        elts.addAll(b);
        for (Object e2 : elts) {
            int m = Math.min(CollectionUtils.getFreq(e2, mapa), CollectionUtils.getFreq(e2, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(e2);
            }
        }
        return list;
    }

    public static <E> Collection<E> disjunction(Collection<E> a, Collection<E> b) {
        ArrayList list = new ArrayList();
        Map<E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<E, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        HashSet<E> elts = new HashSet<E>(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb)) - Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static <E> Collection<E> subtract(Collection<? extends E> a, Iterable<? extends E> b) {
        ArrayList<E> list = new ArrayList<E>(a);
        for (E e2 : b) {
            list.remove(e2);
        }
        return list;
    }

    public static <E> boolean containsAny(Collection<? extends E> coll1, Collection<? extends E> coll2) {
        if (coll1.size() < coll2.size()) {
            Iterator<E> it = coll1.iterator();
            while (it.hasNext()) {
                if (!coll2.contains(it.next())) continue;
                return true;
            }
        } else {
            Iterator<E> it = coll2.iterator();
            while (it.hasNext()) {
                if (!coll1.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayList<String> l1 = new ArrayList<String>();
        l1.add("Test");
        ArrayList<Integer> l2 = new ArrayList<Integer>();
        l2.add(1);
        CollectionUtils.containsAny(l1, l2);
    }

    public static <E> Map<E, Integer> getCardinalityMap(Iterable<E> iterable) {
        HashMap<E, Integer> count = new HashMap<E, Integer>();
        for (E obj : iterable) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, INTEGER_ONE);
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    public static <E> boolean isSubCollection(Iterable<? extends E> a, Iterable<? extends E> b) {
        Map<? extends E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<? extends E, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        for (E obj : a) {
            if (CollectionUtils.getFreq(obj, mapa) <= CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isProperSubCollection(Collection<? extends E> a, Collection<? extends E> b) {
        return a.size() < b.size() && CollectionUtils.isSubCollection(a, b);
    }

    public static <E> boolean isEqualCollection(Collection<? extends E> a, Collection<? extends E> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Map<E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<E, Integer> mapb = CollectionUtils.getCardinalityMap(b);
        if (mapa.size() != mapb.size()) {
            return false;
        }
        for (E obj : mapa.keySet()) {
            if (CollectionUtils.getFreq(obj, mapa) == CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static <E> int cardinality(E obj, Collection<? super E> coll) {
        if (coll instanceof Set) {
            return coll.contains(obj) ? 1 : 0;
        }
        if (coll instanceof Bag) {
            return ((Bag)coll).getCount(obj);
        }
        int count = 0;
        if (obj == null) {
            Iterator<E> it = coll.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                ++count;
            }
        } else {
            Iterator<E> it = coll.iterator();
            while (it.hasNext()) {
                if (!obj.equals(it.next())) continue;
                ++count;
            }
        }
        return count;
    }

    public static <E> E find(Iterable<E> iterable, Predicate<? super E> predicate) {
        if (iterable != null && predicate != null) {
            for (E item : iterable) {
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static <E> void forAllDo(Iterable<E> iterable, Closure<? super E> closure) {
        if (iterable != null && closure != null) {
            Iterator<E> it = iterable.iterator();
            while (it.hasNext()) {
                closure.execute(it.next());
            }
        }
    }

    public static <E> void filter(Iterable<E> iterable, Predicate<? super E> predicate) {
        if (iterable != null && predicate != null) {
            Iterator<E> it = iterable.iterator();
            while (it.hasNext()) {
                if (predicate.evaluate(it.next())) continue;
                it.remove();
            }
        }
    }

    public static <E> void transform(Collection<E> collection, Transformer<? super E, ? extends E> transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<E> it = list.listIterator();
                while (it.hasNext()) {
                    it.set(transformer.transform(it.next()));
                }
            } else {
                Collection<? extends E> resultCollection = CollectionUtils.collect(collection, transformer);
                collection.clear();
                collection.addAll(resultCollection);
            }
        }
    }

    public static <E> int countMatches(Iterable<E> inputIterable, Predicate<? super E> predicate) {
        int count = 0;
        if (inputIterable != null && predicate != null) {
            Iterator<E> it = inputIterable.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                ++count;
            }
        }
        return count;
    }

    public static <E> boolean exists(Iterable<E> iterable, Predicate<? super E> predicate) {
        if (iterable != null && predicate != null) {
            Iterator<E> it = iterable.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> Collection<E> select(Collection<E> inputCollection, Predicate<? super E> predicate) {
        return CollectionUtils.select(inputCollection, predicate, new ArrayList(inputCollection.size()));
    }

    public static <E, C extends Collection<? super E>> C select(Iterable<E> inputCollection, Predicate<? super E> predicate, C outputCollection) {
        if (inputCollection != null && predicate != null) {
            for (E item : inputCollection) {
                if (!predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
        return outputCollection;
    }

    public static <E> Collection<E> selectRejected(Collection<E> inputCollection, Predicate<? super E> predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.selectRejected(inputCollection, predicate, answer);
        return answer;
    }

    public static <E> void selectRejected(Iterable<E> inputIterable, Predicate<? super E> predicate, Collection<? super E> outputCollection) {
        if (inputIterable != null && predicate != null) {
            for (E item : inputIterable) {
                if (predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    public static <I, O> Collection<O> collect(Collection<I> inputCollection, Transformer<? super I, ? extends O> transformer) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.collect(inputCollection, transformer, answer);
        return answer;
    }

    public static <I, O> Collection<O> collect(Iterator<I> inputIterator, Transformer<? super I, ? extends O> transformer) {
        ArrayList answer = new ArrayList();
        CollectionUtils.collect(inputIterator, transformer, answer);
        return answer;
    }

    public static <I, O, C extends Collection<O>> C collect(Iterable<I> inputCollection, Transformer<? super I, ? extends O> transformer, C outputCollection) {
        if (inputCollection != null) {
            return CollectionUtils.collect(inputCollection.iterator(), transformer, outputCollection);
        }
        return outputCollection;
    }

    public static <I, O, C extends Collection<O>> C collect(Iterator<I> inputIterator, Transformer<? super I, ? extends O> transformer, C outputCollection) {
        if (inputIterator != null && transformer != null) {
            while (inputIterator.hasNext()) {
                I item = inputIterator.next();
                O value = transformer.transform(item);
                outputCollection.add(value);
            }
        }
        return outputCollection;
    }

    public static <E> void addAll(Collection<E> collection, Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static <E> void addAll(Collection<E> collection, Enumeration<? extends E> enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static <E, T extends E> void addAll(Collection<E> collection, T ... elements) {
        int size = elements.length;
        for (int i = 0; i < size; ++i) {
            collection.add(elements[i]);
        }
    }

    public static Object index(Object obj, int idx) {
        return CollectionUtils.index(obj, new Integer(idx));
    }

    public static Object index(Object obj, Object index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        int idx = -1;
        if (index instanceof Integer) {
            idx = (Integer)index;
        }
        if (idx < 0) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map2 = (Map)obj;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, idx);
        }
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj)[idx];
        }
        if (obj instanceof Enumeration) {
            Enumeration it = (Enumeration)obj;
            while (it.hasMoreElements()) {
                if (--idx == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
        } else {
            if (obj instanceof Iterator) {
                return CollectionUtils.index((Iterator)obj, idx);
            }
            if (obj instanceof Collection) {
                Iterator iterator = ((Collection)obj).iterator();
                return CollectionUtils.index(iterator, idx);
            }
        }
        return obj;
    }

    private static Object index(Iterator iterator, int idx) {
        while (iterator.hasNext()) {
            if (--idx == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Object get(Object object, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionUtils.get(iterator, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionUtils.get(iterator, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int total = 0;
        if (object instanceof Map) {
            total = ((Map)object).size();
        } else if (object instanceof Collection) {
            total = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            total = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                ++total;
                it.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                total = Array.getLength(object);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return total;
    }

    public static void reverseArray(Object[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static boolean isFull(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).isFull();
        }
        try {
            BoundedCollection bcoll = UnmodifiableBoundedCollection.decorateUsing(coll);
            return bcoll.isFull();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static int maxSize(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).maxSize();
        }
        try {
            BoundedCollection bcoll = UnmodifiableBoundedCollection.decorateUsing(coll);
            return bcoll.maxSize();
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public static <E> Collection<E> synchronizedCollection(Collection<E> collection) {
        return SynchronizedCollection.decorate(collection);
    }

    public static <E> Collection<E> unmodifiableCollection(Collection<E> collection) {
        return UnmodifiableCollection.decorate(collection);
    }

    public static <E> Collection<E> predicatedCollection(Collection<E> collection, Predicate<? super E> predicate) {
        return PredicatedCollection.decorate(collection, predicate);
    }

    public static <E> Collection<E> typedCollection(Collection<E> collection, Class<E> type) {
        return TypedCollection.decorate(collection, type);
    }

    public static <I, O> Collection<O> transformedCollection(Collection<I> collection, Transformer<? super I, ? extends O> transformer) {
        return TransformedCollection.decorate(collection, transformer);
    }
}

