/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.AtomicValue;

public class SequenceWrapper
extends SequenceReceiver {
    public static final String RESULT_NS = QueryResult.RESULT_NS;
    private Receiver out;
    private int depth = 0;
    private int resultSequence;
    private int resultDocument;
    private int resultElement;
    private int resultAttribute;
    private int resultText;
    private int resultComment;
    private int resultPI;
    private int resultNamespace;
    private int resultAtomicValue;
    private int xsiType;

    public SequenceWrapper(Receiver receiver) {
        this.out = receiver;
        this.setPipelineConfiguration(receiver.getPipelineConfiguration());
    }

    public void open() throws XPathException {
        NamePool namePool = this.getNamePool();
        this.resultSequence = namePool.allocate("result", RESULT_NS, "sequence");
        this.resultDocument = namePool.allocate("result", RESULT_NS, "document");
        this.resultElement = namePool.allocate("result", RESULT_NS, "element");
        this.resultAttribute = namePool.allocate("result", RESULT_NS, "attribute");
        this.resultText = namePool.allocate("result", RESULT_NS, "text");
        this.resultComment = namePool.allocate("result", RESULT_NS, "comment");
        this.resultPI = namePool.allocate("result", RESULT_NS, "processing-instruction");
        this.resultNamespace = namePool.allocate("result", RESULT_NS, "namespace");
        this.resultAtomicValue = namePool.allocate("result", RESULT_NS, "atomic-value");
        this.xsiType = namePool.allocate("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type");
        this.out.open();
        this.out.startDocument(0);
        this.out.startElement(this.resultSequence, 641, 0, 0);
        this.out.namespace(namePool.allocateNamespaceCode("result", RESULT_NS), 0);
        this.out.namespace(namePool.allocateNamespaceCode("xs", "http://www.w3.org/2001/XMLSchema"), 0);
        this.out.namespace(namePool.allocateNamespaceCode("xsi", "http://www.w3.org/2001/XMLSchema-instance"), 0);
        this.out.startContent();
    }

    public void startDocument(int n) throws XPathException {
        this.out.startElement(this.resultDocument, 641, 0, 0);
        this.out.startContent();
        ++this.depth;
    }

    public void endDocument() throws XPathException {
        this.out.endElement();
        --this.depth;
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        if (this.depth++ == 0) {
            this.out.startElement(this.resultElement, 641, 0, 0);
            this.out.startContent();
        }
        this.out.startElement(n, n2, n4, n5);
    }

    public void endElement() throws XPathException {
        this.out.endElement();
        if (--this.depth == 0) {
            this.out.endElement();
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultAttribute, 641, 0, 0);
            this.out.attribute(n, n2, charSequence, n4, n5);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.attribute(n, n2, charSequence, n4, n5);
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultNamespace, 641, 0, 0);
            this.out.namespace(n, n2);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.namespace(n, n2);
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultText, 641, 0, 0);
            this.out.startContent();
            this.out.characters(charSequence, n, n2);
            this.out.endElement();
        } else {
            this.out.characters(charSequence, n, n2);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultComment, 641, 0, 0);
            this.out.startContent();
            this.out.comment(charSequence, n, n2);
            this.out.endElement();
        } else {
            this.out.comment(charSequence, n, n2);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultPI, 641, 0, 0);
            this.out.startContent();
            this.out.processingInstruction(string, charSequence, n, n2);
            this.out.endElement();
        } else {
            this.out.processingInstruction(string, charSequence, n, n2);
        }
    }

    public void append(Item item, int n, int n2) throws XPathException {
        if (item instanceof AtomicValue) {
            NamePool namePool = this.getNamePool();
            this.out.startElement(this.resultAtomicValue, 641, 0, 0);
            AtomicType atomicType = (AtomicType)((AtomicValue)item).getItemType(namePool.getTypeHierarchy());
            int n4 = atomicType.getNameCode();
            String string = namePool.getPrefix(n4);
            String string2 = namePool.getLocalName(n4);
            String string3 = namePool.getURI(n4);
            if (string.equals("") && (string = namePool.suggestPrefixForURI(string3)) == null) {
                string = "p" + string3.hashCode();
            }
            int n5 = namePool.allocateNamespaceCode(string, string3);
            String string4 = string + ':' + string2;
            this.out.namespace(n5, 0);
            this.out.attribute(this.xsiType, 642, string4, 0, 0);
            this.out.startContent();
            this.out.characters(item.getStringValue(), 0, 0);
            this.out.endElement();
        } else {
            ((NodeInfo)item).copy(this, 2, true, n);
        }
    }

    public void startContent() throws XPathException {
        this.out.startContent();
    }

    public void close() throws XPathException {
        this.out.endElement();
        this.out.endDocument();
        this.out.close();
    }
}

