/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Whitespace;

public class DeepEqual
extends CollatingFunction {
    public static final int INCLUDE_NAMESPACES = 1;
    public static final int INCLUDE_PREFIXES = 2;
    public static final int INCLUDE_COMMENTS = 4;
    public static final int INCLUDE_PROCESSING_INSTRUCTIONS = 8;
    public static final int EXCLUDE_WHITESPACE_TEXT_NODES = 16;
    public static final int COMPARE_STRING_VALUES = 32;
    public static final int COMPARE_ANNOTATIONS = 64;
    public static final int WARNING_IF_FALSE = 128;
    private transient Configuration config = null;

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        this.config = staticContext.getConfiguration();
        return super.preEvaluate(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        SequenceIterator sequenceIterator2 = this.argument[1].iterate(xPathContext);
        Configuration configuration = this.config != null ? this.config : xPathContext.getConfiguration();
        return BooleanValue.get(DeepEqual.deepEquals(sequenceIterator, sequenceIterator2, atomicComparer, configuration, 0));
    }

    public static boolean deepEquals(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, AtomicComparer atomicComparer, Configuration configuration, int n) {
        String string;
        boolean bl;
        block10: {
            bl = true;
            string = null;
            try {
                while (true) {
                    Item item = sequenceIterator.next();
                    Item item2 = sequenceIterator2.next();
                    if (item == null && item2 == null) break block10;
                    if (item == null || item2 == null) {
                        bl = false;
                        string = "sequences have different lengths";
                        break block10;
                    }
                    if (item instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            if (DeepEqual.deepEquals((NodeInfo)item, (NodeInfo)item2, atomicComparer, configuration, n)) continue;
                            bl = false;
                            string = "nodes at position " + sequenceIterator.position() + " differ";
                        } else {
                            bl = false;
                            string = "comparing a node to an atomic value at position " + sequenceIterator.position();
                        }
                        break block10;
                    }
                    if (item2 instanceof NodeInfo) {
                        bl = false;
                        string = "comparing an atomic value to a node at position " + sequenceIterator.position();
                        break block10;
                    }
                    if (!atomicComparer.comparesEqual(item, item2)) break;
                }
                bl = false;
                string = "atomic values at position " + sequenceIterator.position() + " differ";
            }
            catch (ClassCastException classCastException) {
                bl = false;
                string = "sequences contain non-comparable values";
            }
            catch (XPathException xPathException) {
                bl = false;
                string = "error occurred while comparing two values (" + xPathException.getMessage() + ')';
            }
        }
        if (!bl) {
            DeepEqual.explain(configuration, string, n);
        }
        return bl;
    }

    private static boolean deepEquals(NodeInfo nodeInfo, NodeInfo nodeInfo2, AtomicComparer atomicComparer, Configuration configuration, int n) throws XPathException {
        if (nodeInfo.isSameNodeInfo(nodeInfo2)) {
            return true;
        }
        if (nodeInfo.getNodeKind() != nodeInfo2.getNodeKind()) {
            DeepEqual.explain(configuration, "node kinds differ: comparing " + Type.displayTypeName(nodeInfo) + " to " + Type.displayTypeName(nodeInfo2), n);
            return false;
        }
        NamePool namePool = configuration.getNamePool();
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                int n2;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    DeepEqual.explain(configuration, "element names differ: " + configuration.getNamePool().getClarkName(nodeInfo.getFingerprint()) + " != " + configuration.getNamePool().getClarkName(nodeInfo2.getFingerprint()), n);
                    return false;
                }
                if ((n & 2) != 0 && nodeInfo.getNameCode() != nodeInfo2.getNameCode()) {
                    DeepEqual.explain(configuration, "element prefixes differ: " + nodeInfo.getPrefix() + " != " + nodeInfo2.getPrefix(), n);
                    return false;
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
                AxisIterator axisIterator2 = nodeInfo2.iterateAxis((byte)2);
                if (Aggregate.count(axisIterator.getAnother()) != Aggregate.count(axisIterator2)) {
                    DeepEqual.explain(configuration, "elements have different number of attributes", n);
                    return false;
                }
                while ((object4 = (NodeInfo)axisIterator.next()) != null) {
                    object3 = nodeInfo2.iterateAxis((byte)2, new NameTest(2, object4.getFingerprint(), namePool));
                    object2 = (NodeInfo)object3.next();
                    if (object2 == null) {
                        DeepEqual.explain(configuration, "one element has an attribute " + configuration.getNamePool().getClarkName(object4.getFingerprint()) + ", the other does not", n);
                        return false;
                    }
                    if (DeepEqual.deepEquals((NodeInfo)object4, (NodeInfo)object2, atomicComparer, configuration, n)) continue;
                    DeepEqual.explain(configuration, "elements have different values for the attribute " + configuration.getNamePool().getClarkName(object4.getFingerprint()), n);
                    return false;
                }
                if ((n & 1) != 0) {
                    NodeInfo nodeInfo3;
                    object4 = new IntHashSet(10);
                    object3 = new IntHashSet(10);
                    object2 = nodeInfo.iterateAxis((byte)8);
                    while ((object = (NodeInfo)object2.next()) != null) {
                        int n4 = namePool.getNamespaceCode(object.getLocalPart(), object.getStringValue());
                        ((IntHashSet)object4).add(n4);
                    }
                    object = nodeInfo2.iterateAxis((byte)8);
                    while ((nodeInfo3 = (NodeInfo)object.next()) != null) {
                        n2 = namePool.getNamespaceCode(nodeInfo3.getLocalPart(), nodeInfo3.getStringValue());
                        ((IntHashSet)object3).add(n2);
                    }
                    if (!((IntHashSet)object4).equals(object3)) {
                        DeepEqual.explain(configuration, "elements have different in-scope namespaces", n);
                        return false;
                    }
                }
                if ((n & 0x40) != 0 && nodeInfo.getTypeAnnotation() != nodeInfo2.getTypeAnnotation()) {
                    DeepEqual.explain(configuration, "elements have different type annotation", n);
                    return false;
                }
                if ((n & 0x20) == 0) {
                    int n5 = nodeInfo.getTypeAnnotation();
                    int n6 = nodeInfo2.getTypeAnnotation();
                    if (n5 == -1) {
                        n5 = 641;
                    }
                    if (n6 == -1) {
                        n6 = 641;
                    }
                    object2 = configuration.getSchemaType(n5);
                    object = configuration.getSchemaType(n6);
                    int n7 = object2.isSimpleType() || ((ComplexType)object2).isSimpleContent() ? 1 : 0;
                    int n8 = n2 = object.isSimpleType() || ((ComplexType)object).isSimpleContent() ? 1 : 0;
                    if (n7 != n2) {
                        DeepEqual.explain(configuration, "one element has a simple type, the other does not", n);
                        return false;
                    }
                    if (n7 != 0 && n2 != 0) {
                        SequenceIterator sequenceIterator = nodeInfo.getTypedValue();
                        SequenceIterator sequenceIterator2 = nodeInfo2.getTypedValue();
                        return DeepEqual.deepEquals(sequenceIterator, sequenceIterator2, atomicComparer, configuration, n);
                    }
                }
            }
            case 9: {
                Object object;
                Object object2;
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
                AxisIterator axisIterator3 = nodeInfo2.iterateAxis((byte)3);
                do {
                    boolean bl;
                    object2 = (NodeInfo)axisIterator.next();
                    while (object2 != null && DeepEqual.isIgnorable((NodeInfo)object2, n)) {
                        object2 = (NodeInfo)axisIterator.next();
                    }
                    object = (NodeInfo)axisIterator3.next();
                    while (object != null && DeepEqual.isIgnorable((NodeInfo)object, n)) {
                        object = (NodeInfo)axisIterator3.next();
                    }
                    if (object2 != null && object != null) continue;
                    boolean bl2 = bl = object2 == object;
                    if (!bl) {
                        DeepEqual.explain(configuration, "nodes have different numbers of children", n);
                    }
                    return bl;
                } while (DeepEqual.deepEquals((NodeInfo)object2, (NodeInfo)object, atomicComparer, configuration, n));
                return false;
            }
            case 2: {
                boolean bl;
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    DeepEqual.explain(configuration, "attribute names differ: " + configuration.getNamePool().getClarkName(nodeInfo.getFingerprint()) + " != " + configuration.getNamePool().getClarkName(nodeInfo2.getFingerprint()), n);
                    return false;
                }
                if ((n & 2) != 0 && nodeInfo.getNameCode() != nodeInfo2.getNameCode()) {
                    DeepEqual.explain(configuration, "attribute prefixes differ: " + nodeInfo.getPrefix() + " != " + nodeInfo2.getPrefix(), n);
                    return false;
                }
                if ((n & 0x40) != 0 && nodeInfo.getTypeAnnotation() != nodeInfo2.getTypeAnnotation()) {
                    DeepEqual.explain(configuration, "attributes have different type annotations", n);
                    return false;
                }
                if ((n & 0x20) == 0) {
                    bl = DeepEqual.deepEquals(nodeInfo.getTypedValue(), nodeInfo2.getTypedValue(), atomicComparer, configuration, 0);
                } else {
                    boolean bl3 = bl = atomicComparer.compare(nodeInfo.getStringValue(), nodeInfo2.getStringValue()) == 0;
                }
                if (!bl) {
                    DeepEqual.explain(configuration, "attribute values differ", n);
                }
                return bl;
            }
            case 7: 
            case 13: {
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    DeepEqual.explain(configuration, Type.displayTypeName(nodeInfo) + " names differ", n);
                    return false;
                }
            }
            case 3: 
            case 8: {
                boolean bl = atomicComparer.comparesEqual(nodeInfo.getStringValue(), nodeInfo2.getStringValue());
                if (!bl) {
                    DeepEqual.explain(configuration, Type.displayTypeName(nodeInfo) + " values differ", n);
                }
                return bl;
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static boolean isIgnorable(NodeInfo nodeInfo, int n) {
        int n2 = nodeInfo.getNodeKind();
        if (n2 == 8) {
            return (n & 4) == 0;
        }
        if (n2 == 7) {
            return (n & 8) == 0;
        }
        if (n2 == 3) {
            return (n & 0x10) != 0 && Whitespace.isWhite(nodeInfo.getStringValueCS());
        }
        return false;
    }

    private static void explain(Configuration configuration, String string, int n) {
        try {
            if ((n & 0x80) != 0) {
                configuration.getErrorListener().warning(new DynamicError("deep-equal(): " + string));
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

