/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ForExpression
extends Assignation {
    private transient RangeVariableDeclaration positionVariable = null;
    private PositionBinding positionBinding = null;

    public void setPositionVariable(RangeVariableDeclaration rangeVariableDeclaration) {
        this.positionVariable = rangeVariableDeclaration;
        if (rangeVariableDeclaration != null) {
            this.positionBinding = new PositionBinding(rangeVariableDeclaration.getNameCode());
        }
    }

    public int getPositionVariableNameCode() {
        if (this.positionBinding == null) {
            return -1;
        }
        return this.positionBinding.getNameCode();
    }

    public void setAction(Expression expression) {
        super.setAction(expression);
        if (this.positionVariable != null) {
            this.positionVariable.fixupReferences(this.positionBinding);
        }
    }

    public void setSlotNumber(int n) {
        super.setSlotNumber(n);
        if (this.positionBinding != null) {
            this.positionBinding.setSlotNumber(n + 1);
        }
    }

    public int getRequiredSlots() {
        return this.positionBinding == null ? 1 : 2;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.sequence = this.sequence.typeCheck(staticContext, itemType);
        if (this.sequence instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.declaration != null) {
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            SequenceType sequenceType = this.declaration.getRequiredType();
            SequenceType sequenceType2 = SequenceType.makeSequenceType(sequenceType.getPrimaryType(), 57344);
            RoleLocator roleLocator = new RoleLocator(3, new Integer(this.nameCode), 0, staticContext.getNamePool());
            roleLocator.setSourceLocator(this);
            this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType2, roleLocator, staticContext);
            ItemType itemType2 = this.sequence.getItemType(typeHierarchy);
            this.declaration.refineTypeInformation(itemType2, 16384, null, this.sequence.getSpecialProperties(), staticContext);
        }
        this.action = this.action.typeCheck(staticContext, itemType);
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        Expression expression2 = this.promoteWhereClause(this.positionBinding);
        if (expression2 != null) {
            return expression2.optimize(optimizer, staticContext, itemType);
        }
        Expression expression3 = this.convertWhereToPredicate(optimizer, staticContext, itemType);
        if (expression3 != null && expression3 != this) {
            return expression3.optimize(optimizer, staticContext, itemType);
        }
        int n = 0;
        while (n++ < 5 && (expression = this.sequence.optimize(optimizer, staticContext, itemType)) != this.sequence) {
            this.sequence = expression;
            this.adoptChildExpression(this.sequence);
            this.resetStaticProperties();
        }
        if (this.sequence instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        n = 0;
        while (n++ < 5 && (expression = this.action.optimize(optimizer, staticContext, itemType)) != this.action) {
            this.action = expression;
            this.adoptChildExpression(this.action);
            this.resetStaticProperties();
        }
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        expression = this.extractLoopInvariants(optimizer, staticContext, itemType);
        if (expression != null && expression != this) {
            return expression.optimize(optimizer, staticContext, itemType);
        }
        if (this.declaration != null && this.positionVariable == null && this.sequence instanceof PathExpression && this.action instanceof PathExpression) {
            PathExpression pathExpression;
            int n2 = this.declaration.getReferenceCount(this, staticContext);
            PathExpression pathExpression2 = (PathExpression)this.action;
            Expression expression4 = pathExpression2.getStartExpression();
            if (n2 == 1 && expression4 instanceof VariableReference && ((VariableReference)expression4).getBinding() == this && ((pathExpression = new PathExpression(this.sequence, pathExpression2.getStepExpression())).getSpecialProperties() & 0x20000) != 0) {
                return pathExpression.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            }
        }
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            return this.sequence;
        }
        this.declaration = null;
        return this;
    }

    private Expression extractLoopInvariants(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.positionVariable == null) {
            PromotionOffer promotionOffer = new PromotionOffer(optimizer);
            promotionOffer.containingExpression = this;
            promotionOffer.action = 11;
            Binding[] bindingArray = new Binding[]{this};
            promotionOffer.bindingList = bindingArray;
            Container container2 = this.getParentExpression();
            this.action = this.doPromotion(this.action, promotionOffer);
            if (promotionOffer.containingExpression instanceof LetExpression) {
                ((ComputedExpression)promotionOffer.containingExpression).setParentExpression(container2);
                promotionOffer.containingExpression = promotionOffer.containingExpression.optimize(optimizer, staticContext, itemType);
            }
            return promotionOffer.containingExpression;
        }
        return null;
    }

    public Expression convertWhereToPredicate(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
        if (this.action instanceof IfExpression && ((IfExpression)this.action).getElseExpression() instanceof EmptySequence) {
            Expression expression = null;
            Expression expression2 = this.sequence;
            if (this.sequence instanceof PathExpression && ((PathExpression)this.sequence).isAbsolute(typeHierarchy)) {
                expression = ((PathExpression)this.sequence).getFirstStep();
                expression2 = ((PathExpression)this.sequence).getRemainingSteps();
            }
            boolean bl = false;
            IfExpression ifExpression = (IfExpression)this.action;
            ArrayList arrayList = new ArrayList(4);
            BooleanExpression.listAndComponents(ifExpression.getCondition(), arrayList);
            block0: for (int i = arrayList.size() - 1; i >= 0; --i) {
                Expression expression3;
                Expression expression4;
                Object object;
                Object object2;
                int n;
                Expression[] expressionArray;
                BinaryExpression binaryExpression;
                Expression expression5 = (Expression)arrayList.get(i);
                if (expression5 instanceof ValueComparison) {
                    binaryExpression = (ValueComparison)expression5;
                    expressionArray = binaryExpression.getOperands();
                    for (n = 0; n < 2; ++n) {
                        if (this.positionVariable != null && this.positionVariable.getReferenceList().size() == 1 && !bl && expressionArray[n] instanceof VariableReference && ((VariableReference)expressionArray[n]).getBinding() == this.positionBinding && (expressionArray[1 - n].getDependencies() & 0x1E) == 0) {
                            object2 = SystemFunction.makeSystemFunction("position", 1, staticContext.getNamePool());
                            ((FunctionCall)object2).setArguments(SimpleExpression.NO_ARGUMENTS);
                            object = n == 0 ? new ValueComparison((Expression)object2, binaryExpression.getOperator(), expressionArray[1]) : new ValueComparison(expressionArray[0], binaryExpression.getOperator(), (Expression)object2);
                            expression2 = new FilterExpression(expression2, (Expression)object, staticContext);
                            this.positionVariable = null;
                            this.positionBinding = null;
                            arrayList.remove(i);
                            bl = true;
                            continue block0;
                        }
                        object2 = new Binding[]{this};
                        if (this.positionVariable != null || !ExpressionTool.isVariableReplaceableByDot(expression5, (Binding[])object2) || (expression5.getDependencies() & 0x1E) != 0 || !ExpressionTool.dependsOnVariable(expressionArray[n], (Binding[])object2) || ExpressionTool.dependsOnVariable(expressionArray[1 - n], (Binding[])object2)) continue;
                        object = new PromotionOffer(optimizer);
                        ((PromotionOffer)object).action = 12;
                        ((PromotionOffer)object).bindingList = object2;
                        ((PromotionOffer)object).containingExpression = new ContextItemExpression();
                        expression4 = expressionArray[n].promote((PromotionOffer)object);
                        if (expression4 == null || !((PromotionOffer)object).accepted) continue;
                        expression3 = n == 0 ? new ValueComparison(expression4, binaryExpression.getOperator(), expressionArray[1]) : new ValueComparison(expressionArray[0], binaryExpression.getOperator(), expression4);
                        expression3 = expression3.typeCheck(staticContext, this.sequence.getItemType(typeHierarchy));
                        expression2 = new FilterExpression(expression2, expression3, staticContext);
                        bl = true;
                        this.positionVariable = null;
                        this.positionBinding = null;
                        arrayList.remove(i);
                    }
                    continue;
                }
                if (!(expression5 instanceof GeneralComparison)) continue;
                binaryExpression = (GeneralComparison)expression5;
                expressionArray = binaryExpression.getOperands();
                for (n = 0; n < 2; ++n) {
                    object2 = new Binding[]{this};
                    if (this.positionVariable != null || !ExpressionTool.isVariableReplaceableByDot(expression5, (Binding[])object2) || (expression5.getDependencies() & 0x1E) != 0 || !ExpressionTool.dependsOnVariable(expressionArray[n], (Binding[])object2) || ExpressionTool.dependsOnVariable(expressionArray[1 - n], (Binding[])object2)) continue;
                    object = new PromotionOffer(optimizer);
                    ((PromotionOffer)object).action = 12;
                    ((PromotionOffer)object).bindingList = object2;
                    ((PromotionOffer)object).containingExpression = new ContextItemExpression();
                    expression4 = expressionArray[n].promote((PromotionOffer)object);
                    if (expression4 == null || ExpressionTool.dependsOnVariable(expression4, (Binding[])object2)) continue;
                    if (expression4 instanceof ComputedExpression) {
                        ((ComputedExpression)expression4).resetStaticProperties();
                    }
                    expression3 = n == 0 ? new GeneralComparison(expression4, binaryExpression.getOperator(), expressionArray[1]) : new GeneralComparison(expressionArray[0], binaryExpression.getOperator(), expression4);
                    expression2 = new FilterExpression(expression2, expression3, staticContext);
                    this.resetStaticProperties();
                    this.positionVariable = null;
                    this.positionBinding = null;
                    arrayList.remove(i);
                    bl = true;
                    continue block0;
                }
            }
            if (bl) {
                if (arrayList.isEmpty()) {
                    this.action = ifExpression.getThenExpression();
                    this.adoptChildExpression(this.action);
                } else {
                    Expression expression6 = (Expression)arrayList.get(0);
                    for (int i = 1; i < arrayList.size(); ++i) {
                        expression6 = new BooleanExpression(expression6, 10, (Expression)arrayList.get(i));
                    }
                    ifExpression.setCondition(expression6);
                }
                if (expression == null) {
                    this.sequence = expression2;
                } else {
                    PathExpression pathExpression = new PathExpression(expression, expression2);
                    pathExpression.setParentExpression(this);
                    Expression expression7 = optimizer.convertPathExpressionToKey(pathExpression, staticContext);
                    this.sequence = expression7 == null ? pathExpression : expression7;
                    this.sequence = this.sequence.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
                    this.adoptChildExpression(this.sequence);
                }
                return this;
            }
        }
        return null;
    }

    public boolean markTailFunctionCalls() {
        if (!Cardinality.allowsMany(this.sequence.getCardinality())) {
            return ExpressionTool.markTailFunctionCalls(this.action);
        }
        return false;
    }

    protected Binding[] extendBindingList(Binding[] bindingArray) {
        if (this.positionBinding == null) {
            return super.extendBindingList(bindingArray);
        }
        Binding[] bindingArray2 = new Binding[bindingArray.length + 2];
        System.arraycopy(bindingArray, 0, bindingArray2, 0, bindingArray.length);
        bindingArray2[bindingArray.length] = this;
        bindingArray2[bindingArray.length + 1] = this.positionBinding;
        return bindingArray2;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, false);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        MappingAction mappingAction = new MappingAction(xPathContext, this.slotNumber, this.positionBinding, this.action);
        return new MappingIterator(sequenceIterator, mappingAction, null);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        int n = 1;
        while ((item = sequenceIterator.next()) != null) {
            xPathContext.setLocalVariable(this.slotNumber, item);
            if (this.positionBinding != null) {
                this.positionBinding.setPosition(n++, xPathContext);
            }
            this.action.process(xPathContext);
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        int n = this.sequence.getCardinality();
        int n2 = this.action.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "for $" + this.getVariableName(namePool) + (this.positionVariable == null ? "" : " at $?") + " in");
        this.sequence.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool, printStream);
    }

    protected int getConstructType() {
        return 2012;
    }

    private static class PositionBinding
    implements Binding {
        private int slotNumber;
        private int nameCode;

        public PositionBinding(int n) {
            this.nameCode = n;
        }

        private void setSlotNumber(int n) {
            this.slotNumber = n;
        }

        private void setPosition(int n, XPathContext xPathContext) {
            xPathContext.setLocalVariable(this.slotNumber, new IntegerValue(n));
        }

        public final boolean isGlobal() {
            return false;
        }

        public final boolean isAssignable() {
            return false;
        }

        public int getLocalSlotNumber() {
            return this.slotNumber;
        }

        public int getNameCode() {
            return this.nameCode;
        }

        public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
            return xPathContext.evaluateLocalVariable(this.slotNumber);
        }
    }

    private static class MappingAction
    implements MappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private PositionBinding positionBinding;
        private int position = 1;

        public MappingAction(XPathContext xPathContext, int n, PositionBinding positionBinding, Expression expression) {
            this.context = xPathContext;
            this.slotNumber = n;
            this.positionBinding = positionBinding;
            this.action = expression;
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            if (this.positionBinding != null) {
                this.positionBinding.setPosition(this.position++, this.context);
            }
            return this.action.iterate(this.context);
        }
    }
}

