/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.BreakIteratorFactory;
import com.ibm.icu.text.DictionaryBasedBreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator_New;
import com.ibm.icu.text.RuleBasedBreakIterator_Old;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    private static final boolean ASSERT = false;
    static final ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"Character", "Word", "Line", "Sentence", "Title"};
    private static final String[] KIND_NAMES_2 = new String[]{"char", "word", "line", "sent", "title"};

    BreakIteratorFactory() {
    }

    public Object registerInstance(BreakIterator iter, ULocale locale, int kind) {
        iter.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter, locale, kind);
    }

    public boolean unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt34b");
        }
        return service.getAvailableLocales();
    }

    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt34b");
        }
        return service.getAvailableULocales();
    }

    public BreakIterator createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter = (BreakIterator)service.get(locale, kind, actualLoc);
        iter.setLocale(actualLoc[0], actualLoc[0]);
        return iter;
    }

    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        String prefix = KIND_NAMES[kind];
        return BreakIteratorFactory.createBreakInstance(locale, kind, prefix + "BreakRules", prefix + "BreakDictionary");
    }

    private static BreakIterator createBreakInstance(ULocale where, int kind, String rulesName, String dictionaryName) {
        RuleBasedBreakIterator iter = null;
        ResourceBundle bundle = ICULocaleData.getResourceBundle("BreakIteratorRules", where);
        if (bundle == null) {
            throw new MissingResourceException("No ICU Data", "BreakIteratorRules", where.toString());
        }
        String[] classNames = bundle.getStringArray("BreakIteratorClasses");
        String rules = bundle.getString(rulesName);
        if (classNames[kind].equals("RuleBasedBreakIterator")) {
            iter = new RuleBasedBreakIterator_Old(rules);
        } else {
            if (classNames[kind].equals("RuleBasedBreakIterator_New")) {
                try {
                    String rulesFileName = "data/icudt34b/" + KIND_NAMES_2[kind] + ".brk";
                    InputStream is = ICUData.getStream(rulesFileName);
                    iter = RuleBasedBreakIterator_New.getInstanceFromCompiledRules(is);
                }
                catch (IOException e2) {
                    throw new MissingResourceException(e2.toString(), "", "");
                }
            }
            if (classNames[kind].equals("DictionaryBasedBreakIterator")) {
                try {
                    InputStream dictionary = ICUData.getStream(bundle.getString(dictionaryName));
                    iter = new DictionaryBasedBreakIterator(rules, dictionary);
                }
                catch (IOException e3) {
                }
                catch (MissingResourceException e4) {
                    // empty catch block
                }
                if (iter == null) {
                    iter = new RuleBasedBreakIterator_Old(rules);
                }
            } else {
                throw new IllegalArgumentException("Invalid break iterator class \"" + classNames[kind] + "\"");
            }
        }
        ULocale uloc = ULocale.forLocale(bundle.getLocale());
        iter.setLocale(uloc, uloc);
        return iter;
    }

    static /* synthetic */ BreakIterator access$000(ULocale x0, int x1) {
        return BreakIteratorFactory.createBreakInstance(x0, x1);
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ BFService this$0;

                RBBreakIteratorFactory(BFService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService service) {
                    return BreakIteratorFactory.access$000(loc, kind);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory(this));
            this.markDefault();
        }
    }
}

