/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.cache;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheControl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RandCache
implements Cache,
CacheControl {
    int size;
    int threshhold;
    boolean enabled = true;
    String name;
    HashMap map;
    Collection collection;
    protected static Log logger = LogFactory.getLog(RandCache.class);
    long gets = 0L;
    long puts = 0L;
    long hits = 0L;

    RandCache(String name, int size) {
        this.size = size;
        try {
            this.map = new HashMap(size * 100 / 75);
        }
        catch (IllegalArgumentException e2) {
            if ("Illegal load factor: NaN".equals(e2.getMessage())) {
                logger.warn("Detected a NaN anomaly believed to be due to use of JDK 1.4.1");
                this.map = new HashMap(size * 100 / 75, 0.75f);
            }
            throw e2;
        }
        this.threshhold = size;
        if (this.threshhold < 2) {
            throw new Error("Cache size too small: " + size);
        }
        this.collection = this.map.values();
    }

    public synchronized Object get(Object key) {
        if (this.enabled) {
            if (this.gets == Long.MAX_VALUE) {
                this.forgetStats();
            }
            ++this.gets;
            Object result = this.map.get(key);
            if (result != null) {
                ++this.hits;
            }
            return result;
        }
        return null;
    }

    public synchronized void put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.enabled) {
            if (this.puts == Long.MAX_VALUE) {
                this.forgetStats();
            }
            ++this.puts;
            if (this.map.size() >= this.threshhold) {
                this.makeSpace();
            }
            this.map.put(key, value);
        }
    }

    protected void makeSpace() {
        Iterator iter = this.collection.iterator();
        int size = this.map.size();
        for (int i = 3; i < size; i += 3) {
            iter.next();
            iter.remove();
            iter.next();
            iter.next();
        }
    }

    public synchronized boolean getEnabled() {
        return this.enabled;
    }

    public synchronized boolean setEnabled(boolean enabled) {
        boolean result = enabled;
        this.enabled = enabled;
        return result;
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized long getHits() {
        return this.hits;
    }

    public synchronized long getGets() {
        return this.gets;
    }

    public synchronized long getPuts() {
        return this.puts;
    }

    protected void forgetStats() {
        this.gets /= 2L;
        this.puts /= 2L;
        this.hits /= 2L;
    }
}

