/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.path.PathLib;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public class QueryIterPath
extends QueryIterRepeatApply {
    private TriplePath triplePath;
    private Var varSubject = null;
    private Var varObject = null;

    public QueryIterPath(TriplePath triplePath, QueryIterator input, ExecutionContext context) {
        super(input, context);
        this.triplePath = triplePath;
    }

    protected QueryIterator nextStage(Binding binding) {
        if (this.triplePath.isTriple()) {
            throw new ARQInternalErrorException("TriplePath which is a Triple passed to QueryIterPath");
        }
        QueryIterator qIter = PathLib.execTriplePath(binding, this.triplePath, this.getExecContext());
        return qIter;
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.println();
        out.incIndent();
        out.print(this.triplePath.toString());
        out.decIndent();
    }
}

