/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryEngineRegistry {
    List factories = new ArrayList();
    static QueryEngineRegistry registry;

    public static QueryEngineRegistry get() {
        if (registry == null) {
            QueryEngineRegistry.init();
        }
        return registry;
    }

    private QueryEngineRegistry() {
    }

    private static synchronized void init() {
        registry = new QueryEngineRegistry();
        registry.add(QueryEngineMain.getFactory());
    }

    public static QueryEngineFactory findFactory(Query query2, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(query2, dataset, context);
    }

    public static QueryEngineFactory findFactory(Op op, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(op, dataset, context);
    }

    public QueryEngineFactory find(Query query2, DatasetGraph dataset) {
        return this.find(query2, dataset, null);
    }

    public QueryEngineFactory find(Query query2, DatasetGraph dataset, Context context) {
        ListIterator iter = this.factories.listIterator();
        while (iter.hasNext()) {
            QueryEngineFactory f = (QueryEngineFactory)iter.next();
            if (!f.accept(query2, dataset, context)) continue;
            return f;
        }
        return null;
    }

    public QueryEngineFactory find(Op op, DatasetGraph dataset, Context context) {
        ListIterator iter = this.factories.listIterator();
        while (iter.hasNext()) {
            QueryEngineFactory f = (QueryEngineFactory)iter.next();
            if (!f.accept(op, dataset, context)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().add(f);
    }

    public void add(QueryEngineFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().remove(f);
    }

    public void remove(QueryEngineFactory f) {
        this.factories.remove(f);
    }

    public List factories() {
        return this.factories;
    }

    public static boolean containsFactory(QueryEngineFactory f) {
        return QueryEngineRegistry.get().contains(f);
    }

    public boolean contains(QueryEngineFactory f) {
        return this.factories.contains(f);
    }

    static {
        QueryEngineRegistry.init();
        registry = null;
    }
}

