/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BFRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FRuleEngine
implements FRuleEngineI {
    protected ForwardRuleInfGraphI infGraph;
    protected List rules;
    protected OneToManyMap clauseIndex;
    protected HashSet predicatesUsed;
    protected boolean wildcardRule;
    protected boolean recordDerivations;
    int nRulesTriggered = 0;
    long nRulesFired = 0L;
    long nAxiomRulesFired = -1L;
    boolean processedAxioms = false;
    protected static Log logger = LogFactory.getLog(FRuleEngine.class);

    public FRuleEngine(ForwardRuleInfGraphI parent, List rules) {
        this.infGraph = parent;
        this.rules = rules;
    }

    public FRuleEngine(ForwardRuleInfGraphI parent) {
        this.infGraph = parent;
    }

    public void init(boolean ignoreBrules, Finder inserts) {
        if (this.clauseIndex == null) {
            this.compile(this.rules, ignoreBrules);
        }
        this.findAndProcessAxioms();
        this.nAxiomRulesFired = this.nRulesFired;
        logger.debug("Axioms fired " + this.nAxiomRulesFired + " rules");
        this.fastInit(inserts);
    }

    public void fastInit(Finder inserts) {
        this.findAndProcessActions();
        BFRuleContext context = new BFRuleContext(this.infGraph);
        if (this.wildcardRule) {
            ExtendedIterator i = inserts.find(new TriplePattern(null, null, null));
            while (i.hasNext()) {
                context.addTriple((Triple)i.next());
            }
        } else {
            Iterator p = this.predicatesUsed.iterator();
            while (p.hasNext()) {
                Node predicate = (Node)p.next();
                ExtendedIterator i = inserts.find(new TriplePattern(null, predicate, null));
                while (i.hasNext()) {
                    context.addTriple((Triple)i.next());
                }
            }
        }
        this.addSet(context);
    }

    public synchronized void add(Triple t) {
        BFRuleContext context = new BFRuleContext(this.infGraph);
        context.addTriple(t);
        this.addSet(context);
    }

    public synchronized boolean delete(Triple t) {
        return false;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public boolean shouldTrace() {
        return true;
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    public Object getRuleStore() {
        return new RuleStore(this.clauseIndex, this.predicatesUsed, this.wildcardRule);
    }

    public void setRuleStore(Object ruleStore) {
        RuleStore rs = (RuleStore)ruleStore;
        this.clauseIndex = rs.clauseIndex;
        this.predicatesUsed = rs.predicatesUsed;
        this.wildcardRule = rs.wildcardRule;
    }

    public void addSet(BFRuleContext context) {
        Triple t;
        while ((t = context.getNextTriple()) != null) {
            if (this.infGraph.shouldTrace()) {
                logger.info("Processing: " + PrintUtil.print(t));
            }
            HashSet<Rule> firedRules = new HashSet<Rule>();
            Iterator i1 = this.clauseIndex.getAll(t.getPredicate());
            Iterator i2 = this.clauseIndex.getAll(Node.ANY);
            ConcatenatedIterator i = new ConcatenatedIterator(i1, i2);
            while (i.hasNext()) {
                ClausePointer cp = (ClausePointer)i.next();
                if (firedRules.contains(cp.rule)) continue;
                context.resetEnv(cp.rule.getNumVars());
                TriplePattern trigger = (TriplePattern)cp.rule.getBodyElement(cp.index);
                if (!FRuleEngine.match(trigger, t, context.getEnvStack())) continue;
                ++this.nRulesTriggered;
                context.setRule(cp.rule);
                if (!this.matchRuleBody(cp.index, context)) continue;
                firedRules.add(cp.rule);
                ++this.nRulesFired;
            }
        }
    }

    public void compile(List rules, boolean ignoreBrules) {
        this.clauseIndex = new OneToManyMap();
        this.predicatesUsed = new HashSet();
        this.wildcardRule = false;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (ignoreBrules && r.isBackward()) continue;
            ClauseEntry[] body = r.getBody();
            for (int j = 0; j < body.length; ++j) {
                if (!(body[j] instanceof TriplePattern)) continue;
                Node predicate = ((TriplePattern)body[j]).getPredicate();
                ClausePointer cp = new ClausePointer(r, j);
                if (predicate.isVariable()) {
                    this.clauseIndex.put(Node.ANY, cp);
                    this.wildcardRule = true;
                    continue;
                }
                this.clauseIndex.put(predicate, cp);
                if (this.wildcardRule) continue;
                this.predicatesUsed.add(predicate);
            }
        }
        if (this.wildcardRule) {
            this.predicatesUsed = null;
        }
    }

    protected void findAndProcessAxioms() {
        BFRuleContext context = new BFRuleContext(this.infGraph);
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (r.bodyLength() != 0) continue;
            for (int j = 0; j < r.headLength(); ++j) {
                ClauseEntry head = r.getHeadElement(j);
                if (!(head instanceof TriplePattern)) continue;
                TriplePattern h = (TriplePattern)head;
                Triple t = new Triple(h.getSubject(), h.getPredicate(), h.getObject());
                context.addTriple(t);
                this.infGraph.getDeductionsGraph().add(t);
            }
        }
        this.addSet(context);
        this.processedAxioms = true;
    }

    protected void findAndProcessActions() {
        BFRuleContext context = new BFRuleContext(this.infGraph);
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (r.bodyLength() != 0) continue;
            for (int j = 0; j < r.headLength(); ++j) {
                ClauseEntry head = r.getHeadElement(j);
                if (!(head instanceof Functor)) continue;
                Functor f = (Functor)head;
                Builtin imp = f.getImplementor();
                if (imp != null) {
                    context.setRule(r);
                    imp.headAction(f.getArgs(), f.getArgLength(), context);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + r.toShortString());
            }
        }
    }

    private boolean matchRuleBody(int trigger, BFRuleContext context) {
        boolean matched;
        Rule rule = context.getRule();
        ClauseEntry[] body = rule.getBody();
        int len = body.length;
        ArrayList<ClauseEntry> clauses = new ArrayList<ClauseEntry>(len - 1);
        if (len > 1) {
            if (len == 2) {
                ClauseEntry clause = body[trigger == 0 ? 1 : 0];
                if (clause instanceof TriplePattern) {
                    clauses.add(clause);
                }
            } else {
                int i;
                int bestscore = 0;
                int best = -1;
                for (i = 0; i < len; ++i) {
                    TriplePattern clause;
                    int score;
                    if (i == trigger) continue;
                    BindingStack env = context.getEnvStack();
                    if (!(body[i] instanceof TriplePattern) || (score = FRuleEngine.scoreNodeBoundness((clause = (TriplePattern)body[i]).getSubject(), env) * 3 + FRuleEngine.scoreNodeBoundness(clause.getPredicate(), env) * 2 + FRuleEngine.scoreNodeBoundness(clause.getObject(), env) * 3) <= bestscore) continue;
                    bestscore = score;
                    best = i;
                }
                for (i = 0; i < len; ++i) {
                    if (i == trigger || i == best || !(body[i] instanceof TriplePattern)) continue;
                    clauses.add(body[i]);
                }
                if (best != -1) {
                    clauses.add(body[best]);
                }
            }
        }
        if (matched = this.matchClauseList(clauses, context)) {
            context.flushPending();
        }
        return matched;
    }

    private boolean matchClauseList(List clauses, BFRuleContext context) {
        Rule rule = context.getRule();
        BindingStack env = context.getEnvStack();
        int index = clauses.size() - 1;
        if (index == -1) {
            for (int i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clause = rule.getBodyElement(i);
                if (!(clause instanceof Functor) || ((Functor)clause).evalAsBodyClause(context)) continue;
                return false;
            }
            if (this.infGraph.shouldTrace()) {
                logger.info("Fired rule: " + rule.toShortString() + " = " + rule.instantiate(env));
            }
            ArrayList<Triple> matchList = null;
            if (this.recordDerivations) {
                matchList = new ArrayList<Triple>(rule.bodyLength());
                for (int i = 0; i < rule.bodyLength(); ++i) {
                    ClauseEntry clause = rule.getBodyElement(i);
                    if (!(clause instanceof TriplePattern)) continue;
                    matchList.add(env.instantiate((TriplePattern)clause));
                }
            }
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry hClause = rule.getHeadElement(i);
                if (hClause instanceof TriplePattern) {
                    Triple t = env.instantiate((TriplePattern)hClause);
                    if (t.getSubject().isLiteral() || context.contains(t)) continue;
                    context.add(t);
                    if (!this.recordDerivations) continue;
                    this.infGraph.logDerivation(t, new RuleDerivation(rule, t, matchList, this.infGraph));
                    continue;
                }
                if (hClause instanceof Functor) {
                    Functor f = (Functor)hClause;
                    Builtin imp = f.getImplementor();
                    if (imp != null) {
                        imp.headAction(f.getBoundArgs(env), f.getArgLength(), context);
                        continue;
                    }
                    throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + rule.toShortString());
                }
                if (!(hClause instanceof Rule)) continue;
                Rule r = (Rule)hClause;
                if (r.isBackward()) {
                    this.infGraph.addBRule(r.instantiate(env));
                    continue;
                }
                throw new ReasonerException("Found non-backward subrule : " + r);
            }
            return true;
        }
        ArrayList clausesCopy = (ArrayList)((ArrayList)clauses).clone();
        TriplePattern clause = (TriplePattern)clausesCopy.remove(index);
        Node objPattern = env.getBinding(clause.getObject());
        if (Functor.isFunctor(objPattern)) {
            objPattern = null;
        }
        ExtendedIterator i = this.infGraph.findDataMatches(env.getBinding(clause.getSubject()), env.getBinding(clause.getPredicate()), env.getBinding(objPattern));
        boolean foundMatch = false;
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            env.push();
            if (FRuleEngine.match(clause.getPredicate(), t.getPredicate(), env) && FRuleEngine.match(clause.getObject(), t.getObject(), env) && FRuleEngine.match(clause.getSubject(), t.getSubject(), env)) {
                foundMatch |= this.matchClauseList(clausesCopy, context);
            }
            env.unwind();
        }
        return foundMatch;
    }

    public static int scoreNodeBoundness(Node n, BindingEnvironment env) {
        if (n instanceof Node_ANY) {
            return 0;
        }
        if (n instanceof Node_RuleVariable) {
            Node val = env.getGroundVersion(n);
            if (val == null) {
                return 1;
            }
            if (val.equals(RDF.type.asNode())) {
                return 2;
            }
            return 3;
        }
        return 3;
    }

    public static boolean match(TriplePattern pattern, Triple triple, BindingStack env) {
        boolean matchOK;
        env.push();
        boolean bl = matchOK = FRuleEngine.match(pattern.getPredicate(), triple.getPredicate(), env) && FRuleEngine.match(pattern.getObject(), triple.getObject(), env) && FRuleEngine.match(pattern.getSubject(), triple.getSubject(), env);
        if (matchOK) {
            env.commit();
            return true;
        }
        env.unwind();
        return false;
    }

    public static boolean match(Node pattern, Node node, BindingStack env) {
        if (pattern instanceof Node_RuleVariable) {
            int index = ((Node_RuleVariable)pattern).getIndex();
            return env.bind(index, node);
        }
        if (pattern instanceof Node_ANY) {
            return true;
        }
        if (Functor.isFunctor(pattern)) {
            Node[] nodeArgs;
            if (!Functor.isFunctor(node)) {
                return false;
            }
            Functor patternF = (Functor)pattern.getLiteralValue();
            Functor nodeF = (Functor)node.getLiteralValue();
            if (!patternF.getName().equals(nodeF.getName())) {
                return false;
            }
            Node[] patternArgs = patternF.getArgs();
            if (patternArgs.length != (nodeArgs = nodeF.getArgs()).length) {
                return false;
            }
            env.push();
            boolean matchOK = true;
            for (int i = 0; i < patternArgs.length; ++i) {
                if (FRuleEngine.match(patternArgs[i], nodeArgs[i], env)) continue;
                matchOK = false;
                break;
            }
            if (matchOK) {
                env.commit();
                return true;
            }
            env.unwind();
            return false;
        }
        return pattern.sameValueAs(node);
    }

    public static class RuleStore {
        protected OneToManyMap clauseIndex;
        protected HashSet predicatesUsed;
        protected boolean wildcardRule;

        RuleStore(OneToManyMap clauseIndex, HashSet predicatesUsed, boolean wildcardRule) {
            this.clauseIndex = clauseIndex;
            this.predicatesUsed = predicatesUsed;
            this.wildcardRule = wildcardRule;
        }
    }

    protected static class ClausePointer {
        protected Rule rule;
        protected int index;

        ClausePointer(Rule rule, int index) {
            this.rule = rule;
            this.index = index;
        }

        TriplePattern getClause() {
            return (TriplePattern)this.rule.getBodyElement(this.index);
        }
    }
}

