/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BFRuleContext
implements RuleContext {
    protected BindingStack env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected List stack;
    protected List pending;
    protected List deletesPending = new ArrayList();
    protected Graph pendingCache;
    protected static Log logger = LogFactory.getLog(BFRuleContext.class);

    public BFRuleContext(ForwardRuleInfGraphI graph) {
        this.graph = graph;
        this.env = new BindingStack();
        this.stack = new ArrayList();
        this.pending = new ArrayList();
        this.pendingCache = Factory.createGraphMem();
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public BindingStack getEnvStack() {
        return this.env;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addTriple(Triple t) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug("Adding to stack (" + this.rule.toShortString() + "): " + PrintUtil.print(t));
            } else {
                logger.debug("Adding to stack : " + PrintUtil.print(t));
            }
        }
        this.stack.add(t);
    }

    public void add(Triple t) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug("Adding to pending (" + this.rule.toShortString() + "): " + PrintUtil.print(t));
            } else {
                logger.debug("Adding to pending : " + PrintUtil.print(t));
            }
        }
        this.pending.add(t);
    }

    public void flushPending() {
        Triple t;
        Iterator i = this.pending.iterator();
        while (i.hasNext()) {
            t = (Triple)i.next();
            this.stack.add(t);
            this.graph.addDeduction(t);
            i.remove();
        }
        this.pending.clear();
        i = this.deletesPending.iterator();
        while (i.hasNext()) {
            t = (Triple)i.next();
            this.graph.delete(t);
        }
        this.deletesPending.clear();
    }

    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public boolean contains(Node s, Node p, Node o) {
        ClosableIterator it = this.find(s, p, o);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public ClosableIterator find(Node s, Node p, Node o) {
        return this.graph.findDataMatches(s, p, o);
    }

    public Triple getNextTriple() {
        if (this.stack.size() > 0) {
            Triple t = (Triple)this.stack.remove(this.stack.size() - 1);
            return t;
        }
        return null;
    }

    public void resetEnv(int newSize) {
        this.env.reset(newSize);
    }

    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    public void remove(Triple t) {
        this.deletesPending.add(t);
    }
}

