/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilder;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class IndexBuilderBase
implements IndexBuilder {
    private Directory dir = null;
    private IndexWriter indexWriter = null;

    public IndexBuilderBase() {
        this.dir = new RAMDirectory();
        this.makeIndex();
    }

    public IndexBuilderBase(IndexWriter existingWriter) {
        this.dir = existingWriter.getDirectory();
        this.indexWriter = existingWriter;
    }

    public IndexBuilderBase(File fileDir) {
        try {
            this.dir = FSDirectory.getDirectory(fileDir);
            this.makeIndex();
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    public IndexBuilderBase(String fileDir) {
        try {
            this.dir = FSDirectory.getDirectory(fileDir);
            this.makeIndex();
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    private void makeIndex() {
        try {
            this.indexWriter = new IndexWriter(this.dir, (Analyzer)new StandardAnalyzer(), true);
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    protected IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    protected IndexReader getIndexReader() {
        try {
            this.flushWriter();
            return IndexReader.open(this.dir);
        }
        catch (Exception e2) {
            throw new ARQLuceneException("getIndexReader", e2);
        }
    }

    public void closeWriter() {
        this.closeWriter(true);
    }

    public void closeWriter(boolean optimize) {
        if (optimize) {
            this.flushWriter();
        }
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
        }
        catch (IOException ex) {
            throw new ARQLuceneException("closeIndex", ex);
        }
        this.indexWriter = null;
    }

    public void flushWriter() {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.optimize();
            }
        }
        catch (IOException ex) {
            throw new ARQLuceneException("flushWriter", ex);
        }
    }

    public void closeForWriting() {
        this.closeForWriting(true);
    }

    public void closeForWriting(boolean optimize) {
        try {
            if (this.indexWriter != null) {
                this.flushWriter();
            }
        }
        catch (Exception e2) {
            throw new ARQLuceneException("close", e2);
        }
    }

    public IndexLARQ getIndex() {
        return new IndexLARQ(this.getIndexReader());
    }
}

