/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.lang.ParserRegistry;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.util.FileManager;

public class QueryFactory {
    public static Query create(String queryString) {
        return QueryFactory.create(queryString, Syntax.defaultSyntax);
    }

    public static Query create(String queryString, Syntax langURI) {
        return QueryFactory.create(queryString, null, langURI);
    }

    public static Query create(String queryString, String baseURI) {
        Query query2 = new Query();
        QueryFactory.parse(query2, queryString, baseURI, Syntax.defaultSyntax);
        return query2;
    }

    public static Query create(String queryString, String baseURI, Syntax querySyntax) {
        Query query2 = new Query();
        QueryFactory.parse(query2, queryString, baseURI, querySyntax);
        return query2;
    }

    public static Query make() {
        return new Query();
    }

    public static Query create(Query originalQuery) {
        return originalQuery.cloneQuery();
    }

    public static Query parse(Query query2, String queryString, String baseURI, Syntax syntaxURI) {
        if (syntaxURI == null) {
            syntaxURI = query2.getSyntax();
        } else {
            query2.setSyntax(syntaxURI);
        }
        Parser parser = Parser.createParser(syntaxURI);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing: " + syntaxURI);
        }
        if (query2.getResolver() == null) {
            try {
                baseURI = IRIResolver.chooseBaseURI(baseURI);
            }
            catch (Exception ex) {
                baseURI = "http://localhost/defaultBase#";
            }
            query2.setResolver(new IRIResolver(baseURI));
        }
        return parser.parse(query2, queryString);
    }

    static boolean knownParserSyntax(Syntax syntaxURI) {
        return ParserRegistry.get().containsFactory(syntaxURI);
    }

    public static Query read(String url) {
        return QueryFactory.read(url, null, null, null);
    }

    public static Query read(String url, String baseURI) {
        return QueryFactory.read(url, null, baseURI, null);
    }

    public static Query read(String url, Syntax langURI) {
        return QueryFactory.read(url, null, null, langURI);
    }

    public static Query read(String url, String baseURI, Syntax langURI) {
        return QueryFactory.read(url, null, baseURI, langURI);
    }

    public static Query read(String url, FileManager filemanager, String baseURI, Syntax langURI) {
        if (filemanager == null) {
            filemanager = FileManager.get();
        }
        String qStr = filemanager.readWholeFileAsUTF8(url);
        if (baseURI == null) {
            baseURI = url;
        }
        if (langURI == null) {
            langURI = Syntax.guessQueryFileSyntax(url);
        }
        return QueryFactory.create(qStr, baseURI, langURI);
    }

    public static Element createElement(String elementString) {
        return ParserSPARQL.parseElement(elementString);
    }

    public static Template createTemplate(String templateString) {
        return ParserSPARQL.parseTemplate(templateString);
    }
}

