### R code from vignette source 'immunoClust.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: stage0
###################################################
library(immunoClust)


###################################################
### code chunk number 3: stage1data
###################################################
data(dat.fcs)
dat.fcs


###################################################
### code chunk number 4: stage1cluster
###################################################
pars=c("FSC-A","SSC-A","FITC-A","PE-A","APC-A","APC-Cy7-A","Pacific Blue-A")
res.fcs <- cell.process(dat.fcs, parameters=pars)


###################################################
### code chunk number 5: stage1summary
###################################################
summary(res.fcs)


###################################################
### code chunk number 6: stage1bias
###################################################
res2 <- cell.process(dat.fcs, bias=0.25)
summary(res2)


###################################################
### code chunk number 7: stage1trans
###################################################
dat.transformed <- trans.ApplyToData(res.fcs, dat.fcs)


###################################################
### code chunk number 8: stage1splom
###################################################
splom(res.fcs, dat.transformed, N=1000)


###################################################
### code chunk number 9: stage1plot
###################################################
plot(res.fcs, data=dat.transformed, subset=c(1,2))


###################################################
### code chunk number 10: stage2data
###################################################
data(dat.exp)
meta<-meta.process(dat.exp, meta.bias=0.3)


###################################################
### code chunk number 11: stage2plot
###################################################
plot(meta, c())


###################################################
### code chunk number 12: stage2events
###################################################
cls <- clusters(meta,c())
events(meta,cls)


###################################################
### code chunk number 13: stage2annotation
###################################################
addLevel(meta,c(1),"leucocytes") <- c(1,2,6,7,10,14,18)


###################################################
### code chunk number 14: stage2plot1
###################################################
plot(meta, c(1))


###################################################
### code chunk number 15: stage2annotation
###################################################
cls <- clusters(meta,c(1))
sort(mu(meta,cls,7))        ## CD3 expression
inc <- mu(meta,cls,7) > 5   ## CD3+ clusters
cls[inc]
mu(meta,cls[inc],6)         ## CD4 expression
addLevel(meta,c(1,1), "CD3+CD4+") <- 10
addLevel(meta,c(1,2), "CD3+CD4-") <- 2
cls <- unclassified(meta,c(1))
sort(mu(meta,cls,5))        ## CD15 expression
inc <- mu(meta,cls,5) > 3
addLevel(meta,c(1,3), "CD15+") <- cls[inc]
cls <- unclassified(meta,c(1))
sort(mu(meta,cls,3))        ## CD14 expression
inc <- mu(meta,cls,3) > 5
addLevel(meta,c(1,4), "CD14+") <- cls[inc]
cls <- unclassified(meta,c(1))
sort(mu(meta,cls,4))        ## CD19 expression
inc <- mu(meta,cls,4) > 3
addLevel(meta,c(1,5), "CD19+") <- cls[inc]


###################################################
### code chunk number 16: stage2export
###################################################
tbl <- meta.numEvents(meta, out.all=FALSE)
tbl[,1:5]


###################################################
### code chunk number 17: stage2annotation
###################################################
move(meta,c(1,4)) <- 13


###################################################
### code chunk number 18: stage2final
###################################################
plot(meta, c(1))


###################################################
### code chunk number 19: sessionInfo
###################################################
toLatex(sessionInfo())


