/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.util;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.systemsbiology.gaggle.util.TextFileReader;
import org.systemsbiology.gaggle.util.TextHttpReader;
import org.systemsbiology.gaggle.util.TextJarReader;

public class NewNameHelper
implements Serializable {
    protected String uri;
    protected String rawText;
    protected String[] titles = new String[0];
    protected HashMap map = new HashMap();
    protected HashMap canonicalToCommonMap = new HashMap();
    protected HashMap commonToCanonicalMap = new HashMap();

    public NewNameHelper(String uri) throws Exception {
        String protocol;
        this.uri = uri;
        int positionOfProtocolChars = uri.indexOf("://");
        if (positionOfProtocolChars < 0) {
            uri = "file://" + uri;
            positionOfProtocolChars = uri.indexOf("://");
        }
        if ((protocol = uri.substring(0, positionOfProtocolChars + 3)).equals("file://")) {
            String filename = uri.substring(7);
            File file = new File(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot find file named '" + filename + "'");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file named '" + filename + "'");
            }
            TextFileReader reader = new TextFileReader(file.getPath());
            reader.read();
            this.rawText = reader.getText();
        } else if (protocol.equals("jar://")) {
            TextJarReader reader = new TextJarReader(uri);
            reader.read();
            this.rawText = reader.getText();
        } else if (protocol.equals("http://")) {
            TextHttpReader reader = new TextHttpReader(uri);
            reader.read();
            this.rawText = reader.getText();
        }
        if (this.rawText != null) {
            this.parseText(this.rawText);
        }
    }

    public String getRawText() {
        return this.rawText;
    }

    protected void parseText(String rawText) {
        String[] lines = rawText.split("\n");
        this.titles = lines[0].split("\t");
        for (int i = 1; i < lines.length; ++i) {
            String[] tokens = lines[i].split("\t");
            String canonicalName = tokens[0];
            String commonName = tokens[1];
            HashMap<String, String> info = new HashMap<String, String>();
            if (commonName != null && !"".equals(commonName)) {
                info.put("commonName", commonName);
            }
            for (int col = 0; col < this.titles.length; ++col) {
                if (tokens[col] == null || "".equals(tokens[col])) continue;
                info.put(this.titles[col], tokens[col]);
            }
            this.map.put(canonicalName, info);
            this.map.put(commonName, info);
            this.canonicalToCommonMap.put(canonicalName, commonName);
            this.commonToCanonicalMap.put(commonName, canonicalName);
        }
    }

    public String[] getTitles() {
        return this.titles;
    }

    public String[] getCanonicalNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    public HashMap getInfo(String canonicalName) {
        return (HashMap)this.map.get(canonicalName);
    }

    public String getCommonName(String canonicalName) {
        return (String)this.canonicalToCommonMap.get(canonicalName);
    }

    public String getCanonicalName(String commonName) {
        return (String)this.commonToCanonicalMap.get(commonName);
    }
}

