/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.BooleanOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedBooleanArray {
    private AtomicIntegerArray myArray;

    public SharedBooleanArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedBooleanArray(boolean[] blArray) {
        int n = blArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public boolean get(int n) {
        return this.myArray.get(n) != 0;
    }

    public void set(int n, boolean bl) {
        this.myArray.set(n, bl ? 1 : 0);
    }

    public boolean getAndSet(int n, boolean bl) {
        return this.myArray.getAndSet(n, bl ? 1 : 0) != 0;
    }

    public boolean compareAndSet(int n, boolean bl, boolean bl2) {
        return this.myArray.compareAndSet(n, bl ? 1 : 0, bl2 ? 1 : 0);
    }

    public boolean weakCompareAndSet(int n, boolean bl, boolean bl2) {
        return this.myArray.weakCompareAndSet(n, bl ? 1 : 0, bl2 ? 1 : 0);
    }

    public boolean reduce(int n, boolean bl, BooleanOp booleanOp) {
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3, n2 = booleanOp.op((n3 = this.myArray.get(n)) != 0, bl) ? 1 : 0)) {
        }
        return n2 != 0;
    }

    public void reduce(boolean[] blArray, BooleanOp booleanOp) {
        this.reduce(0, blArray, 0, this.myArray.length(), booleanOp);
    }

    public void reduce(int n, boolean[] blArray, int n2, int n3, BooleanOp booleanOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > blArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            int n4;
            int n5;
            while (!this.myArray.compareAndSet(n, n5, n4 = booleanOp.op((n5 = this.myArray.get(n)) != 0, blArray[n2]) ? 1 : 0)) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

