/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.LongSchedule;
import edu.rit.util.LongRange;
import java.util.concurrent.atomic.AtomicLong;

class GuidedLongSchedule
extends LongSchedule {
    private int two_K;
    private LongRange myLoopRange;
    private long myLoopRangeLength;
    private AtomicLong N1 = new AtomicLong();
    private long N2;

    public GuidedLongSchedule() {
        this(1L);
    }

    public GuidedLongSchedule(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Minimum chunk size = " + l + " illegal");
        }
        this.N2 = l;
    }

    public GuidedLongSchedule(String[] stringArray) {
        this(GuidedLongSchedule.getChunkSize(stringArray));
    }

    private static long getChunkSize(String[] stringArray) {
        long l;
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Usage: -Dpj.schedule=guided or -Dpj.schedule=\"guided(<n>)\"");
        }
        try {
            l = Long.parseLong(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Chunk size = " + stringArray[0] + " illegal");
        }
        return l;
    }

    public boolean isFixedSchedule() {
        return false;
    }

    public void start(int n, LongRange longRange) {
        this.two_K = 2 * n;
        this.myLoopRange = longRange;
        this.myLoopRangeLength = longRange.length();
        this.N1.set(0L);
    }

    public LongRange next(int n) {
        LongRange longRange;
        long l;
        long l2;
        long l3;
        do {
            if ((l = (longRange = this.myLoopRange.chunk(l3 = this.N1.get(), Math.max(this.N2, (this.myLoopRangeLength - l3) / (long)this.two_K))).length()) != 0L) continue;
            return null;
        } while (!this.N1.compareAndSet(l3, l2 = l3 + l));
        return longRange;
    }
}

