/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.TooManyIterationsException;
import edu.rit.numeric.VectorFunction;

public class NonLinearLeastSquares {
    public final VectorFunction fcn;
    public final int M;
    public final int N;
    public final double[] x;
    public final double[] fvec;
    public final double[][] fjac;
    public final int[] ipvt;
    public double tol = 1.0E-6;
    public int info;
    public int nprint = 0;
    private double[] diag;
    private double[] qtf;
    private double[] wa1;
    private double[] wa2;
    private double[] wa3;
    private double[] wa4;
    private int nfev;
    private int njev;
    private static final double dpmpar_1 = 2.22044604926E-16;
    private static final double dpmpar_2 = 2.22507385852E-308;
    private static final double dpmpar_3 = 1.79769313485E308;
    private static final double rdwarf = 3.834E-20;
    private static final double rgiant = 1.304E19;

    public NonLinearLeastSquares(VectorFunction vectorFunction) {
        this.fcn = vectorFunction;
        this.M = vectorFunction.resultLength();
        this.N = vectorFunction.argumentLength();
        if (this.M <= 0) {
            throw new IllegalArgumentException("NonLinearLeastSquares(): M (= " + this.M + ") <= 0, illegal");
        }
        if (this.N <= 0) {
            throw new IllegalArgumentException("NonLinearLeastSquares(): N (= " + this.N + ") <= 0, illegal");
        }
        if (this.M < this.N) {
            throw new IllegalArgumentException("NonLinearLeastSquares(): M (= " + this.M + ") < N (= " + this.N + "), illegal");
        }
        this.x = new double[this.N];
        this.fvec = new double[this.M];
        this.fjac = new double[this.M][this.N];
        this.ipvt = new int[this.N];
        this.diag = new double[this.N];
        this.qtf = new double[this.N];
        this.wa1 = new double[this.N];
        this.wa2 = new double[this.N];
        this.wa3 = new double[this.N];
        this.wa4 = new double[this.M];
    }

    public void solve() {
        this.info = 0;
        if (this.tol < 0.0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.solve(): tol (= " + this.tol + ") < 0, illegal");
        }
        this.lmder(this.tol, this.tol, 0.0, 100 * (this.N + 1), 1, 100.0);
        if (this.info == 5) {
            throw new TooManyIterationsException("NonLinearLeastSquares.solve(): Too many iterations");
        }
        if (this.info == 8) {
            this.info = 4;
        }
    }

    private void lmder(double d, double d2, double d3, int n, int n2, double d4) {
        int n3;
        double d5 = 2.22044604926E-16;
        this.info = 0;
        this.nfev = 0;
        this.njev = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d < 0.0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): ftol (= " + d + ") < 0, illegal");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): xtol (= " + d2 + ") < 0, illegal");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): gtol (= " + d3 + ") < 0, illegal");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): maxfev (= " + n + ") <= 0, illegal");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): factor (= " + d4 + ") <= 0, illegal");
        }
        if (n2 == 2) {
            for (n3 = 0; n3 < this.N; ++n3) {
                if (!(this.diag[n3] <= 0.0)) continue;
                throw new IllegalArgumentException("NonLinearLeastSquares.lmder(): diag[" + n3 + "] (= " + this.diag[n3] + ") <= 0, illegal");
            }
        }
        this.fcn.f(this.x, this.fvec);
        ++this.nfev;
        double d8 = NonLinearLeastSquares.enorm(this.M, this.fvec);
        double d9 = 0.0;
        int n4 = 1;
        block1: while (true) {
            double d10;
            int n5;
            double d11;
            int n6;
            double d12;
            this.fcn.df(this.x, this.fjac);
            ++this.njev;
            if (this.nprint > 0 && (n4 - 1) % this.nprint == 0) {
                this.subclassDebug(n4);
            }
            NonLinearLeastSquares.qrfac(this.M, this.N, this.fjac, true, this.ipvt, this.wa1, this.wa2, this.wa3);
            if (n4 == 1) {
                if (n2 != 2) {
                    for (n3 = 1; n3 < this.N; ++n3) {
                        this.diag[n3] = this.wa2[n3];
                        if (this.wa2[n3] != 0.0) continue;
                        this.diag[n3] = 1.0;
                    }
                }
                for (n3 = 0; n3 < this.N; ++n3) {
                    this.wa3[n3] = this.diag[n3] * this.x[n3];
                }
                d7 = NonLinearLeastSquares.enorm(this.N, this.wa3);
                d6 = d4 * d7;
                if (d6 == 0.0) {
                    d6 = d4;
                }
            }
            for (n3 = 0; n3 < this.M; ++n3) {
                this.wa4[n3] = this.fvec[n3];
            }
            for (n3 = 0; n3 < this.N; ++n3) {
                if (this.fjac[n3][n3] != 0.0) {
                    d12 = 0.0;
                    for (n6 = n3; n6 < this.M; ++n6) {
                        d12 += this.fjac[n6][n3] * this.wa4[n6];
                    }
                    d11 = -d12 / this.fjac[n3][n3];
                    for (n6 = n3; n6 < this.M; ++n6) {
                        int n7 = n6;
                        this.wa4[n7] = this.wa4[n7] + this.fjac[n6][n3] * d11;
                    }
                }
                this.fjac[n3][n3] = this.wa1[n3];
                this.qtf[n3] = this.wa4[n3];
            }
            double d13 = 0.0;
            if (d8 != 0.0) {
                for (n3 = 0; n3 < this.N; ++n3) {
                    n5 = this.ipvt[n3];
                    if (this.wa2[n5] == 0.0) continue;
                    d12 = 0.0;
                    for (n6 = 0; n6 <= n3; ++n6) {
                        d12 += this.fjac[n6][n3] * (this.qtf[n6] / d8);
                    }
                    d13 = Math.max(d13, Math.abs(d12 / this.wa2[n5]));
                }
            }
            if (d13 <= d3) {
                this.info = 4;
                break;
            }
            if (n2 != 2) {
                for (n3 = 0; n3 < this.N; ++n3) {
                    this.diag[n3] = Math.max(this.diag[n3], this.wa2[n3]);
                }
            }
            do {
                d9 = NonLinearLeastSquares.lmpar(this.N, this.fjac, this.ipvt, this.diag, this.qtf, d6, d9, this.wa1, this.wa2, this.wa3, this.wa4);
                for (n3 = 0; n3 < this.N; ++n3) {
                    this.wa1[n3] = -this.wa1[n3];
                    this.wa2[n3] = this.x[n3] + this.wa1[n3];
                    this.wa3[n3] = this.diag[n3] * this.wa1[n3];
                }
                double d14 = NonLinearLeastSquares.enorm(this.N, this.wa3);
                if (n4 == 1) {
                    d6 = Math.min(d6, d14);
                }
                this.fcn.f(this.wa2, this.wa4);
                ++this.nfev;
                double d15 = NonLinearLeastSquares.enorm(this.M, this.wa4);
                double d16 = -1.0;
                if (0.1 * d15 < d8) {
                    d16 = 1.0 - NonLinearLeastSquares.sqr(d15 / d8);
                }
                for (n3 = 0; n3 < this.N; ++n3) {
                    this.wa3[n3] = 0.0;
                    n5 = this.ipvt[n3];
                    d11 = this.wa1[n5];
                    for (n6 = 0; n6 <= n3; ++n6) {
                        int n8 = n6;
                        this.wa3[n8] = this.wa3[n8] + this.fjac[n6][n3] * d11;
                    }
                }
                double d17 = NonLinearLeastSquares.enorm(this.N, this.wa3) / d8;
                double d18 = Math.sqrt(d9) * d14 / d8;
                double d19 = NonLinearLeastSquares.sqr(d17) + NonLinearLeastSquares.sqr(d18) * 2.0;
                double d20 = -(NonLinearLeastSquares.sqr(d17) + NonLinearLeastSquares.sqr(d18));
                d10 = 0.0;
                if (d19 != 0.0) {
                    d10 = d16 / d19;
                }
                if (d10 <= 0.25) {
                    double d21 = d11 = d16 >= 0.0 ? 0.5 : 0.5 * d20 / (d20 + 0.5 * d16);
                    if (0.1 * d15 >= d8 || d11 < 0.1) {
                        d11 = 0.1;
                    }
                    d6 = d11 * Math.min(d6, d14 * 10.0);
                    d9 /= d11;
                } else if (d9 == 0.0 || d10 >= 0.75) {
                    d6 = d14 * 2.0;
                    d9 = 0.5 * d9;
                }
                if (d10 >= 1.0E-4) {
                    for (n3 = 0; n3 < this.N; ++n3) {
                        this.x[n3] = this.wa2[n3];
                        this.wa2[n3] = this.diag[n3] * this.x[n3];
                    }
                    for (n3 = 0; n3 < this.M; ++n3) {
                        this.fvec[n3] = this.wa4[n3];
                    }
                    d7 = NonLinearLeastSquares.enorm(this.N, this.wa2);
                    d8 = d15;
                    ++n4;
                }
                n3 = Math.abs(d16) <= d && d19 <= d && d10 <= 2.0 ? 1 : 0;
                n6 = d6 <= d2 * d7 ? 1 : 0;
                this.info = (n3 != 0 ? 1 : 0) + (n6 != 0 ? 2 : 0);
                if (this.info != 0) break block1;
                if (this.nfev >= n) {
                    this.info = 5;
                }
                if (Math.abs(d16) <= d5 && d19 <= d5 && d10 <= 2.0) {
                    this.info = 6;
                }
                if (d6 <= d5 * d7) {
                    this.info = 7;
                }
                if (d13 <= d5) {
                    this.info = 8;
                }
                if (this.info != 0) break block1;
            } while (!(d10 >= 1.0E-4));
        }
        if (this.nprint > 0) {
            this.subclassDebug(n4);
        }
    }

    private static double lmpar(int n, double[][] dArray, int[] nArray, double[] dArray2, double[] dArray3, double d, double d2, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        double d3;
        int n2;
        double d4;
        int n3;
        double d5 = 2.22507385852E-308;
        int n4 = n;
        for (n3 = 0; n3 < n; ++n3) {
            dArray6[n3] = dArray3[n3];
            if (dArray[n3][n3] == 0.0 && n4 == n) {
                n4 = n3;
            }
            if (n4 >= n) continue;
            dArray6[n3] = 0.0;
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            dArray6[n3] = dArray6[n3] / dArray[n3][n3];
            d4 = dArray6[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = n2;
                dArray6[n5] = dArray6[n5] - dArray[n2][n3] * d4;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            dArray4[nArray[n3]] = dArray6[n3];
        }
        int n6 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            dArray7[n3] = dArray2[n3] * dArray4[n3];
        }
        double d6 = NonLinearLeastSquares.enorm(n, dArray7);
        double d7 = d6 - d;
        if (d7 <= 0.1 * d) {
            return 0.0;
        }
        double d8 = 0.0;
        if (n4 == n) {
            for (n3 = 0; n3 < n; ++n3) {
                n2 = nArray[n3];
                dArray6[n3] = dArray2[n2] * (dArray7[n2] / d6);
            }
            for (n3 = 0; n3 < n; ++n3) {
                d3 = 0.0;
                for (n2 = 0; n2 < n3; ++n2) {
                    d3 += dArray[n2][n3] * dArray6[n2];
                }
                dArray6[n3] = (dArray6[n3] - d3) / dArray[n3][n3];
            }
            d4 = NonLinearLeastSquares.enorm(n, dArray6);
            d8 = d7 / d / d4 / d4;
        }
        for (n3 = 0; n3 < n; ++n3) {
            d3 = 0.0;
            for (n2 = 0; n2 <= n3; ++n2) {
                d3 += dArray[n2][n3] * dArray3[n2];
            }
            dArray6[n3] = d3 / dArray2[nArray[n3]];
        }
        double d9 = NonLinearLeastSquares.enorm(n, dArray6);
        double d10 = d9 / d;
        if (d10 == 0.0) {
            d10 = d5 / Math.min(d, 0.1);
        }
        d2 = Math.max(d2, d8);
        if ((d2 = Math.min(d2, d10)) == 0.0) {
            d2 = d9 / d6;
        }
        while (true) {
            ++n6;
            if (d2 == 0.0) {
                d2 = Math.max(d5, 0.001 * d10);
            }
            d4 = Math.sqrt(d2);
            for (n3 = 0; n3 < n; ++n3) {
                dArray6[n3] = d4 * dArray2[n3];
            }
            NonLinearLeastSquares.qrsolv(n, dArray, nArray, dArray6, dArray3, dArray4, dArray5, dArray7);
            for (n3 = 0; n3 < n; ++n3) {
                dArray7[n3] = dArray2[n3] * dArray4[n3];
            }
            d6 = NonLinearLeastSquares.enorm(n, dArray7);
            d4 = d7;
            d7 = d6 - d;
            if (Math.abs(d7) <= 0.1 * d || d8 == 0.0 && d7 <= d4 && d4 < 0.0 || n6 == 10) break;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = nArray[n3];
                dArray6[n3] = dArray2[n2] * (dArray7[n2] / d6);
            }
            for (n3 = 0; n3 < n; ++n3) {
                int n7 = n3;
                dArray6[n7] = dArray6[n7] / dArray5[n3];
                d4 = dArray6[n3];
                for (n2 = n3 + 1; n2 < n; ++n2) {
                    int n8 = n2;
                    dArray6[n8] = dArray6[n8] - dArray[n2][n3] * d4;
                }
            }
            d4 = NonLinearLeastSquares.enorm(n, dArray6);
            double d11 = d7 / d / d4 / d4;
            if (d7 > 0.0) {
                d8 = Math.max(d8, d2);
            }
            if (d7 < 0.0) {
                d10 = Math.min(d10, d2);
            }
            d2 = Math.max(d8, d2 + d11);
        }
        return d2;
    }

    private static void qrfac(int n, int n2, double[][] dArray, boolean bl, int[] nArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n3;
        double d = 2.22044604926E-16;
        for (n3 = 0; n3 < n2; ++n3) {
            dArray3[n3] = NonLinearLeastSquares.enorm(n, dArray, 0, n3);
            dArray2[n3] = dArray3[n3];
            dArray4[n3] = dArray2[n3];
            if (!bl) continue;
            nArray[n3] = n3;
        }
        int n4 = Math.min(n, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            double d2;
            double d3;
            int n5;
            if (bl) {
                int n6 = n3;
                for (n5 = n3; n5 < n2; ++n5) {
                    if (!(dArray2[n5] > dArray2[n6])) continue;
                    n6 = n5;
                }
                if (n6 != n3) {
                    for (n5 = 0; n5 < n; ++n5) {
                        d3 = dArray[n5][n3];
                        dArray[n5][n3] = dArray[n5][n6];
                        dArray[n5][n6] = d3;
                    }
                    dArray2[n6] = dArray2[n3];
                    dArray4[n6] = dArray4[n3];
                    int n7 = nArray[n3];
                    nArray[n3] = nArray[n6];
                    nArray[n6] = n7;
                }
            }
            if ((d2 = NonLinearLeastSquares.enorm(n, dArray, n3, n3)) != 0.0) {
                if (dArray[n3][n3] < 0.0) {
                    d2 = -d2;
                }
                for (n5 = n3; n5 < n; ++n5) {
                    double[] dArray5 = dArray[n5];
                    int n8 = n3;
                    dArray5[n8] = dArray5[n8] / d2;
                }
                double[] dArray6 = dArray[n3];
                int n9 = n3;
                dArray6[n9] = dArray6[n9] + 1.0;
                for (n5 = n3 + 1; n5 < n2; ++n5) {
                    int n10;
                    double d4 = 0.0;
                    for (n10 = n3; n10 < n; ++n10) {
                        d4 += dArray[n10][n3] * dArray[n10][n5];
                    }
                    d3 = d4 / dArray[n3][n3];
                    for (n10 = n3; n10 < n; ++n10) {
                        double[] dArray7 = dArray[n10];
                        int n11 = n5;
                        dArray7[n11] = dArray7[n11] - d3 * dArray[n10][n3];
                    }
                    if (!bl || dArray2[n5] == 0.0) continue;
                    d3 = dArray[n3][n5] / dArray2[n5];
                    int n12 = n5;
                    dArray2[n12] = dArray2[n12] * Math.sqrt(Math.max(0.0, 1.0 - NonLinearLeastSquares.sqr(d3)));
                    if (!(0.05 * NonLinearLeastSquares.sqr(dArray2[n5] / dArray4[n5]) <= d)) continue;
                    dArray2[n5] = NonLinearLeastSquares.enorm(n, dArray, n3 + 1, n5);
                    dArray4[n5] = dArray2[n5];
                }
            }
            dArray2[n3] = -d2;
        }
    }

    private static void qrsolv(int n, double[][] dArray, int[] nArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n2;
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3; n2 < n; ++n2) {
                dArray[n2][n3] = dArray[n3][n2];
            }
            dArray4[n3] = dArray[n3][n3];
            dArray6[n3] = dArray3[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            if (dArray2[n2] != 0.0) {
                int n4;
                for (n4 = n3; n4 < n; ++n4) {
                    dArray5[n4] = 0.0;
                }
                dArray5[n3] = dArray2[n2];
                double d = 0.0;
                for (n4 = n3; n4 < n; ++n4) {
                    double d2;
                    double d3;
                    if (dArray5[n4] == 0.0) continue;
                    if (Math.abs(dArray[n4][n4]) < Math.abs(dArray5[n4])) {
                        double d4 = dArray[n4][n4] / dArray5[n4];
                        d3 = 0.5 / Math.sqrt(0.25 + 0.25 * NonLinearLeastSquares.sqr(d4));
                        d2 = d3 * d4;
                    } else {
                        double d5 = dArray5[n4] / dArray[n4][n4];
                        d2 = 0.5 / Math.sqrt(0.25 + 0.25 * NonLinearLeastSquares.sqr(d5));
                        d3 = d2 * d5;
                    }
                    dArray[n4][n4] = d2 * dArray[n4][n4] + d3 * dArray5[n4];
                    double d6 = d2 * dArray6[n4] + d3 * d;
                    d = -d3 * dArray6[n4] + d2 * d;
                    dArray6[n4] = d6;
                    for (int i = n4 + 1; i < n; ++i) {
                        d6 = d2 * dArray[i][n4] + d3 * dArray5[i];
                        dArray5[i] = -d3 * dArray[i][n4] + d2 * dArray5[i];
                        dArray[i][n4] = d6;
                    }
                }
            }
            dArray5[n3] = dArray[n3][n3];
            dArray[n3][n3] = dArray4[n3];
        }
        int n5 = n;
        for (n3 = 0; n3 < n; ++n3) {
            if (dArray5[n3] == 0.0 && n5 == n) {
                n5 = n3;
            }
            if (n5 >= n) continue;
            dArray6[n3] = 0.0;
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            double d = 0.0;
            for (n2 = n3 + 1; n2 < n5; ++n2) {
                d += dArray[n2][n3] * dArray6[n2];
            }
            dArray6[n3] = (dArray6[n3] - d) / dArray5[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            dArray4[nArray[n3]] = dArray6[n3];
        }
    }

    private static double enorm(int n, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.304E19 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d7 = Math.abs(dArray[i]);
            if (d7 >= d6) {
                if (d7 > d4) {
                    d = 1.0 + d * NonLinearLeastSquares.sqr(d4 / d7);
                    d4 = d7;
                    continue;
                }
                d += NonLinearLeastSquares.sqr(d7 / d4);
                continue;
            }
            if (d7 <= 3.834E-20) {
                if (d7 > d5) {
                    d3 = 1.0 + d3 * NonLinearLeastSquares.sqr(d5 / d7);
                    d5 = d7;
                    continue;
                }
                if (d7 == 0.0) continue;
                d3 += NonLinearLeastSquares.sqr(d7 / d5);
                continue;
            }
            d2 += NonLinearLeastSquares.sqr(d7);
        }
        if (d != 0.0) {
            return d4 * Math.sqrt(d + d2 / d4 / d4);
        }
        if (d2 != 0.0) {
            if (d2 >= d5) {
                return Math.sqrt(d2 * (1.0 + d5 / d2 * (d5 * d3)));
            }
            return Math.sqrt(d5 * (d2 / d5 + d5 * d3));
        }
        return d5 * Math.sqrt(d3);
    }

    private static double enorm(int n, double[][] dArray, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.304E19 / (double)n;
        for (int i = n2; i < n; ++i) {
            double d7 = Math.abs(dArray[i][n3]);
            if (d7 >= d6) {
                if (d7 > d4) {
                    d = 1.0 + d * NonLinearLeastSquares.sqr(d4 / d7);
                    d4 = d7;
                    continue;
                }
                d += NonLinearLeastSquares.sqr(d7 / d4);
                continue;
            }
            if (d7 <= 3.834E-20) {
                if (d7 > d5) {
                    d3 = 1.0 + d3 * NonLinearLeastSquares.sqr(d5 / d7);
                    d5 = d7;
                    continue;
                }
                if (d7 == 0.0) continue;
                d3 += NonLinearLeastSquares.sqr(d7 / d5);
                continue;
            }
            d2 += NonLinearLeastSquares.sqr(d7);
        }
        if (d != 0.0) {
            return d4 * Math.sqrt(d + d2 / d4 / d4);
        }
        if (d2 != 0.0) {
            if (d2 >= d5) {
                return Math.sqrt(d2 * (1.0 + d5 / d2 * (d5 * d3)));
            }
            return Math.sqrt(d5 * (d2 / d5 + d5 * d3));
        }
        return d5 * Math.sqrt(d3);
    }

    private static double sqr(double d) {
        return d * d;
    }

    protected void subclassDebug(int n) {
    }
}

