/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.XYSeries;
import edu.rit.util.Sorting;

public class Interpolation
implements Function {
    private double[] xData;
    private double[] yData;
    private int NM2;
    private int myIndex;
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public Interpolation(XYSeries xYSeries) {
        int n;
        int n2 = xYSeries.length();
        if (n2 < 2) {
            throw new IllegalArgumentException("Interpolation(): theSeries length < 2");
        }
        this.xData = new double[n2];
        this.yData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = xYSeries.x(n);
            this.yData[n] = xYSeries.y(n);
        }
        Sorting.sort(this.xData, new Sorting.Double(){

            public void swap(double[] dArray, int n, int n2) {
                double d = Interpolation.this.xData[n];
                ((Interpolation)Interpolation.this).xData[n] = Interpolation.this.xData[n2];
                ((Interpolation)Interpolation.this).xData[n2] = d;
                d = Interpolation.this.yData[n];
                ((Interpolation)Interpolation.this).yData[n] = Interpolation.this.yData[n2];
                ((Interpolation)Interpolation.this).yData[n2] = d;
            }
        });
        this.NM2 = n2 - 2;
        for (n = 0; n <= this.NM2; ++n) {
            if (this.xData[n] != this.xData[n + 1]) continue;
            throw new IllegalArgumentException("Interpolation(): Duplicate X value: " + this.xData[n]);
        }
        this.myIndex = 0;
        this.x1 = this.xData[0];
        this.y1 = this.yData[0];
        this.x2 = this.xData[1];
        this.y2 = this.yData[1];
    }

    public double f(double d) {
        while (this.myIndex < this.NM2 && d >= this.x2) {
            ++this.myIndex;
            this.x1 = this.x2;
            this.y1 = this.y2;
            this.x2 = this.xData[this.myIndex + 1];
            this.y2 = this.yData[this.myIndex + 1];
        }
        while (this.myIndex > 0 && d < this.x1) {
            --this.myIndex;
            this.x2 = this.x1;
            this.y2 = this.y1;
            this.x1 = this.xData[this.myIndex];
            this.y1 = this.yData[this.myIndex];
        }
        double d2 = (d - this.x1) / (this.x2 - this.x1);
        return (1.0 - d2) * this.y1 + d2 * this.y2;
    }
}

