/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelSignal;
import edu.rit.mri.PixelTissues;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.mri.TissuesDataSetReader;
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.Series;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import edu.rit.numeric.plot.impl.LinearAxis;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;

public class PlotPixel {
    private PlotPixel() {
    }

    public static void main(String[] stringArray) throws Exception {
        File file = null;
        File file2 = null;
        int n = 0;
        if (stringArray.length == 2) {
            file = new File(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        } else if (stringArray.length == 3) {
            file = new File(stringArray[0]);
            file2 = new File(stringArray[1]);
            n = Integer.parseInt(stringArray[2]);
        } else {
            PlotPixel.usage();
        }
        SignalDataSetReader signalDataSetReader = new SignalDataSetReader(file);
        Series series = signalDataSetReader.getTimeSeries();
        PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(n);
        signalDataSetReader.close();
        if (pixelSignal == null) {
            System.err.println("PlotPixel: Pixel " + n + " has no data");
            System.exit(0);
        }
        Series series2 = pixelSignal.S_measured();
        int n2 = series.length();
        int n3 = 0;
        Series series3 = null;
        if (file2 != null) {
            TissuesDataSetReader tissuesDataSetReader = new TissuesDataSetReader(file2);
            PixelTissues pixelTissues = tissuesDataSetReader.getPixelTissues(n);
            tissuesDataSetReader.close();
            if (pixelTissues == null) {
                System.out.println("No solution found");
            } else {
                n3 = pixelTissues.numTissues();
                if (n3 == 0) {
                    System.out.println("No solution found");
                } else {
                    double d;
                    int n4;
                    series3 = pixelTissues.S_series(series);
                    System.out.println("rho\tR1\tT1");
                    for (int i = 0; i < n3; ++i) {
                        System.out.print(pixelTissues.rho(i));
                        System.out.print('\t');
                        System.out.print(pixelTissues.R1(i));
                        System.out.print('\t');
                        System.out.print(1.0 / pixelTissues.R1(i));
                        System.out.println();
                    }
                    double d2 = 0.0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        d = series2.x(n4) - series3.x(n4);
                        d2 += d * d;
                    }
                    System.out.print("chi^2 = ");
                    System.out.print(d2);
                    System.out.println();
                    n4 = n2 - 2 * n3;
                    System.out.print("dof   = ");
                    System.out.print(n4);
                    System.out.println();
                    d = Math.sqrt(d2 / (double)n4);
                    System.out.print("sigma = ");
                    System.out.print(d);
                    System.out.println();
                }
            }
        }
        double d = 0.0;
        d = Math.max(d, Math.abs(series2.minX()));
        d = Math.max(d, Math.abs(series2.maxX()));
        if (n3 > 0) {
            d = Math.max(d, Math.abs(series3.minX()));
            d = Math.max(d, Math.abs(series3.maxX()));
        }
        d = LinearAxis.autoscale(d);
        Plot plot = new Plot();
        plot.plotTitle("Spin Signal vs. Time for Pixel " + n).leftMargin(72.0).xAxisLength(576.0).xAxisMajorDivisions(20).yAxisLength(288.0).xAxisTitle("Time, <I>t</I> (sec)").yAxisMajorDivisions(10).yAxisStart(-d).yAxisEnd(d).yAxisTickFormat(new DecimalFormat("0.0E0")).yAxisTitle("Spin signal, <I>S</I> (<I>t</I>)").yAxisTitleOffset(54.0).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(null).xySeries(new AggregateXYSeries(series, series2));
        if (n3 > 0) {
            plot.seriesDots(null).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(new AggregateXYSeries(series, series3));
        }
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.PlotPixel <signalfile> [<tissuesfile>] <index>");
        System.err.println("<signalfile> = Spin signal data set file");
        System.err.println("<tissuesfile> = Tissues data set file");
        System.err.println("<index> = Pixel index");
        System.exit(1);
    }
}

