/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongArrayBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class LongArrayReductionBuf
extends LongArrayBuf {
    LongOp myOp;

    public LongArrayReductionBuf(long[] lArray, Range range, LongOp longOp) {
        super(lArray, range);
        if (longOp == null) {
            throw new NullPointerException("LongArrayReductionBuf(): op is null");
        }
        this.myOp = longOp;
    }

    public void put(int n, long l) {
        int n2 = this.myArrayOffset + n * this.myStride;
        this.myArray[n2] = this.myOp.op(this.myArray[n2], l);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof LongArrayBuf) {
                LongArrayBuf longArrayBuf = (LongArrayBuf)buf;
                ReduceArrays.reduce(longArrayBuf.myArray, longArrayBuf.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                LongBuf.defaultCopy((LongBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 8) {
            this.myArray[n4] = this.myOp.op(this.myArray[n4], byteBuffer.getLong());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

