/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerArrayBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class IntegerArrayReductionBuf
extends IntegerArrayBuf {
    IntegerOp myOp;

    public IntegerArrayReductionBuf(int[] nArray, Range range, IntegerOp integerOp) {
        super(nArray, range);
        if (integerOp == null) {
            throw new NullPointerException("IntegerArrayReductionBuf(): op is null");
        }
        this.myOp = integerOp;
    }

    public void put(int n, int n2) {
        int n3 = this.myArrayOffset + n * this.myStride;
        this.myArray[n3] = this.myOp.op(this.myArray[n3], n2);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof IntegerArrayBuf) {
                IntegerArrayBuf integerArrayBuf = (IntegerArrayBuf)buf;
                ReduceArrays.reduce(integerArrayBuf.myArray, integerArrayBuf.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                IntegerBuf.defaultCopy((IntegerBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 4) {
            this.myArray[n4] = this.myOp.op(this.myArray[n4], byteBuffer.getInt());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

