/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import edu.rit.mp.LoopbackChannel;
import edu.rit.mp.NetworkChannel;
import edu.rit.mp.Status;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import edu.rit.util.Range;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.LinkedList;
import java.util.List;

public class ChannelGroup {
    int myChannelGroupId;
    ServerSocketChannel myServerSocketChannel;
    IORequestList myIORequestList;
    ClassLoader myClassLoader;
    LoopbackChannel myLoopbackChannel;
    List<Channel> myChannelList;
    AcceptThread myAcceptThread;
    ConnectListener myConnectListener;
    Logger myLogger;
    TimerThread myTimerThread;

    public ChannelGroup() {
        this(new PrintStreamLogger());
    }

    public ChannelGroup(InetSocketAddress inetSocketAddress) throws IOException {
        this(inetSocketAddress, (Logger)new PrintStreamLogger());
    }

    public ChannelGroup(ServerSocketChannel serverSocketChannel) throws IOException {
        this(serverSocketChannel, (Logger)new PrintStreamLogger());
    }

    public ChannelGroup(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("ChannelGroup(): theLogger is null");
        }
        this.myIORequestList = new IORequestList();
        this.myLoopbackChannel = new LoopbackChannel(this);
        this.myChannelList = new LinkedList<Channel>();
        this.myChannelList.add(this.myLoopbackChannel);
        this.myLogger = logger;
        this.myTimerThread = new TimerThread();
        this.myTimerThread.setDaemon(true);
        this.myTimerThread.start();
    }

    public ChannelGroup(InetSocketAddress inetSocketAddress, Logger logger) throws IOException {
        this(logger);
        this.listen(inetSocketAddress);
    }

    public ChannelGroup(ServerSocketChannel serverSocketChannel, Logger logger) throws IOException {
        this(logger);
        this.listen(serverSocketChannel);
    }

    public void setChannelGroupId(int n) {
        this.myChannelGroupId = n;
    }

    public int getChannelGroupId() {
        return this.myChannelGroupId;
    }

    public synchronized InetSocketAddress listenAddress() {
        return this.myServerSocketChannel == null ? null : (InetSocketAddress)this.myServerSocketChannel.socket().getLocalSocketAddress();
    }

    public synchronized void listen(InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new NullPointerException("ChannelGroup.listen(): theListenAddress is null");
        }
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(inetSocketAddress);
        this.listen(serverSocketChannel);
    }

    public synchronized void listen(ServerSocketChannel serverSocketChannel) throws IOException {
        if (serverSocketChannel == null) {
            throw new NullPointerException("ChannelGroup.listen(): theServerSocketChannel is null");
        }
        if (!serverSocketChannel.socket().isBound()) {
            throw new IOException("ChannelGroup.listen(): theServerSocketChannel is not bound");
        }
        if (this.myAcceptThread != null) {
            throw new IllegalStateException("ChannelGroup.listen(): Listening has already started");
        }
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.listen(): Channel group closed");
        }
        this.myServerSocketChannel = serverSocketChannel;
    }

    public synchronized void setConnectListener(ConnectListener connectListener) {
        this.myConnectListener = connectListener;
    }

    public synchronized void startListening() {
        if (this.myServerSocketChannel == null) {
            throw new IllegalStateException("ChannelGroup.startListening(): No server socket channel");
        }
        if (this.myAcceptThread != null) {
            throw new IllegalStateException("ChannelGroup.listen(): Listening has already started");
        }
        this.myAcceptThread = new AcceptThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect(InetSocketAddress inetSocketAddress) throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.myIORequestList == null) {
                throw new IOException("ChannelGroup.connect(): Channel group closed");
            }
        }
        object = null;
        try {
            object = SocketChannel.open(inetSocketAddress);
            return this.nearEndConnect((SocketChannel)object);
        }
        catch (IOException iOException) {
            Thread.interrupted();
            if (object != null) {
                try {
                    ((AbstractInterruptibleChannel)object).close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    public synchronized Channel loopbackChannel() {
        return this.myLoopbackChannel;
    }

    public void send(Channel channel, Buf buf) throws IOException {
        IORequest iORequest = new IORequest();
        this.sendNoWait(channel, 0, buf, iORequest);
        iORequest.waitForFinish();
    }

    public void send(Channel channel, int n, Buf buf) throws IOException {
        IORequest iORequest = new IORequest();
        this.sendNoWait(channel, n, buf, iORequest);
        iORequest.waitForFinish();
    }

    public void sendNoWait(Channel channel, Buf buf, IORequest iORequest) throws IOException {
        this.sendNoWait(channel, 0, buf, iORequest);
    }

    public void sendNoWait(Channel channel, int n, Buf buf, IORequest iORequest) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.sendNoWait(): Channel group closed");
        }
        if (buf == null) {
            throw new NullPointerException("ChannelGroup.sendNoWait(): Source buffer is null");
        }
        iORequest.initialize(channel, n, n, buf);
        channel.send(iORequest);
    }

    public Status receive(Channel channel, Buf buf) throws IOException {
        IORequest iORequest = new IORequest();
        this.receiveNoWait(channel, 0, 0, buf, iORequest);
        return iORequest.waitForFinish();
    }

    public Status receive(Channel channel, int n, Buf buf) throws IOException {
        IORequest iORequest = new IORequest();
        this.receiveNoWait(channel, n, n, buf, iORequest);
        return iORequest.waitForFinish();
    }

    public Status receive(Channel channel, Range range, Buf buf) throws IOException {
        IORequest iORequest = new IORequest();
        if (range == null) {
            this.receiveNoWait(channel, Integer.MIN_VALUE, Integer.MAX_VALUE, buf, iORequest);
        } else {
            this.receiveNoWait(channel, range.lb(), range.ub(), buf, iORequest);
        }
        return iORequest.waitForFinish();
    }

    public void receiveNoWait(Channel channel, Buf buf, IORequest iORequest) throws IOException {
        this.receiveNoWait(channel, 0, 0, buf, iORequest);
    }

    public void receiveNoWait(Channel channel, int n, Buf buf, IORequest iORequest) throws IOException {
        this.receiveNoWait(channel, n, n, buf, iORequest);
    }

    public void receiveNoWait(Channel channel, Range range, Buf buf, IORequest iORequest) throws IOException {
        if (range == null) {
            this.receiveNoWait(channel, Integer.MIN_VALUE, Integer.MAX_VALUE, buf, iORequest);
        } else {
            this.receiveNoWait(channel, range.lb(), range.ub(), buf, iORequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveNoWait(Channel channel, int n, int n2, Buf buf, IORequest iORequest) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.receiveNoWait(): Channel group closed");
        }
        if (buf == null) {
            throw new NullPointerException("ChannelGroup.receiveNoWait(): Destination buffer is null");
        }
        if (channel != null) {
            Channel channel2 = channel;
            synchronized (channel2) {
                if (channel.myReadState == 1) {
                    throw new IOException("ChannelGroup.receiveNoWait(): Channel closed");
                }
            }
        }
        iORequest.initialize(channel, n, n2, buf);
        this.myIORequestList.add(iORequest);
    }

    public synchronized void setAlternateClassLoader(ClassLoader classLoader) {
        this.myClassLoader = classLoader;
    }

    public synchronized void close() {
        if (this.myServerSocketChannel != null) {
            try {
                this.myServerSocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myChannelList != null) {
            while (!this.myChannelList.isEmpty()) {
                this.myChannelList.get(0).close();
            }
        }
        if (this.myIORequestList != null) {
            this.myIORequestList.reportFailure(new ChannelGroupClosedException("Channel group closed"));
        }
        this.myServerSocketChannel = null;
        this.myIORequestList = null;
        this.myClassLoader = null;
        this.myLoopbackChannel = null;
        this.myChannelList = null;
        this.myAcceptThread = null;
    }

    protected void finalize() {
        this.close();
    }

    public void dump(PrintStream printStream, String string) {
        printStream.println(string + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        printStream.println(string + "myChannelGroupId = " + this.myChannelGroupId);
        printStream.println(string + "myServerSocketChannel = " + this.myServerSocketChannel);
        printStream.println(string + "myIORequestList:");
        this.myIORequestList.dump(printStream, string + "\t");
        printStream.println(string + "myClassLoader = " + this.myClassLoader);
        printStream.println(string + "myLoopbackChannel = " + this.myLoopbackChannel);
        printStream.println(string + "myChannelList:");
        printStream.println(string + "\t" + this.myChannelList.size() + " entries");
        for (Channel channel : this.myChannelList) {
            channel.dump(printStream, string + "\t");
        }
        printStream.println(string + "myAcceptThread = " + this.myAcceptThread);
        printStream.println(string + "myConnectListener = " + this.myConnectListener);
        printStream.println(string + "myLogger = " + this.myLogger);
        printStream.println(string + "myTimerThread = " + this.myTimerThread);
    }

    Channel nearEndConnect(SocketChannel socketChannel) throws IOException {
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(true);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(this.myChannelGroupId);
        byteBuffer.flip();
        if (socketChannel.write(byteBuffer) != 4) {
            throw new IOException("ChannelGroup.nearEndConnect(): Cannot send channel group ID");
        }
        byteBuffer.clear();
        final Thread thread = Thread.currentThread();
        Timer timer = this.myTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                thread.interrupt();
            }
        });
        timer.start(30000L);
        if (socketChannel.read(byteBuffer) != 4) {
            throw new IOException("ChannelGroup.nearEndConnect(): Cannot receive channel group ID");
        }
        timer.stop();
        byteBuffer.flip();
        int n = byteBuffer.getInt();
        Channel channel = this.createNetworkChannel(socketChannel, n);
        if (this.myConnectListener != null) {
            this.myConnectListener.nearEndConnected(this, channel);
        }
        channel.start();
        return channel;
    }

    Channel farEndConnect(SocketChannel socketChannel) throws IOException {
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(true);
        final Thread thread = Thread.currentThread();
        Timer timer = this.myTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                thread.interrupt();
            }
        });
        timer.start(30000L);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            if (socketChannel.read(byteBuffer) != 4) {
                throw new IOException("ChannelGroup.farEndConnect(): Cannot receive channel group ID");
            }
            timer.stop();
            byteBuffer.flip();
            int n = byteBuffer.getInt();
            byteBuffer.clear();
            byteBuffer.putInt(this.myChannelGroupId);
            byteBuffer.flip();
            if (socketChannel.write(byteBuffer) != 4) {
                throw new IOException("ChannelGroup.farEndConnect(): Cannot send channel group ID");
            }
            Channel channel = this.createNetworkChannel(socketChannel, n);
            if (this.myConnectListener != null) {
                this.myConnectListener.farEndConnected(this, channel);
            }
            channel.start();
            return channel;
        }
        catch (IOException iOException) {
            timer.stop();
            throw iOException;
        }
    }

    synchronized Channel createNetworkChannel(SocketChannel socketChannel, int n) throws IOException {
        NetworkChannel networkChannel = null;
        if (this.myIORequestList != null) {
            networkChannel = new NetworkChannel(this, socketChannel, n);
            this.myChannelList.add(networkChannel);
        }
        return networkChannel;
    }

    synchronized void removeChannel(Channel channel) {
        if (this.myChannelList != null) {
            this.myChannelList.remove(channel);
        }
    }

    private class AcceptThread
    extends Thread {
        public AcceptThread() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                SocketChannel socketChannel = null;
                try {
                    socketChannel = ChannelGroup.this.myServerSocketChannel.accept();
                }
                catch (ClosedChannelException closedChannelException) {
                    ChannelGroup.this.myLogger.log("ChannelGroup: Channel closed", (Throwable)closedChannelException);
                    break;
                }
                catch (IOException iOException) {
                    ChannelGroup.this.myLogger.log("ChannelGroup: I/O error while accepting connection", (Throwable)iOException);
                    break;
                }
                if (socketChannel == null) continue;
                try {
                    ChannelGroup.this.farEndConnect(socketChannel);
                }
                catch (IOException iOException) {
                    Thread.interrupted();
                    ChannelGroup.this.myLogger.log("ChannelGroup: I/O error while setting up channel", (Throwable)iOException);
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
        }
    }
}

