/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.MaximumParsimonyResults;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.replica.ReplicatedInteger;
import java.io.IOException;

public class MaximumParsimonyBnbHyb {
    private DnaSequenceList seqList;
    private ReplicatedInteger bound;
    private MaximumParsimonyResults results;
    private int L;
    private int N;
    private int C;
    private int[] absentStates;
    private DnaSequenceTree[] treeStack;
    DnaSequence[][] seqArrayStack;
    private int[] signature;
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private long p9;
    private long pa;
    private long pb;
    private long pc;
    private long pd;
    private long pe;
    private long pf;

    public static ReplicatedInteger createBoundVariable(int n) {
        return MaximumParsimonyBnbHyb.createBoundVariable(n, Comm.world(), Integer.MAX_VALUE);
    }

    public static ReplicatedInteger createBoundVariable(int n, Comm comm, int n2) {
        return new ReplicatedInteger(IntegerOp.MINIMUM, n, n2, comm);
    }

    public MaximumParsimonyBnbHyb(DnaSequenceList dnaSequenceList, ReplicatedInteger replicatedInteger, MaximumParsimonyResults maximumParsimonyResults) {
        int n;
        this.seqList = dnaSequenceList;
        this.bound = replicatedInteger;
        this.results = maximumParsimonyResults;
        this.L = dnaSequenceList.seq(0).length();
        this.N = dnaSequenceList.length();
        this.C = 2 * this.N - 1;
        this.absentStates = dnaSequenceList.countAbsentStates();
        this.treeStack = new DnaSequenceTree[this.N];
        for (n = 0; n < this.N; ++n) {
            this.treeStack[n] = new DnaSequenceTree(this.C);
        }
        this.treeStack[0].add(0, dnaSequenceList.seq(0));
        this.seqArrayStack = new DnaSequence[this.N][];
        for (n = 0; n < this.N; ++n) {
            DnaSequence[] dnaSequenceArray = new DnaSequence[n];
            this.seqArrayStack[n] = dnaSequenceArray;
            for (int i = 0; i < n; ++i) {
                dnaSequenceArray[i] = new DnaSequence(this.L);
            }
        }
        this.signature = new int[this.N + 32];
    }

    public void findTrees(int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        this.signature[0] = 0;
        int n6 = n2;
        for (n5 = n; n5 > 0; --n5) {
            n4 = 2 * n5 - 1;
            this.signature[n5] = n6 % n4 - 1;
            n6 /= n4;
        }
        for (n5 = n + 1; n5 < this.N; ++n5) {
            this.signature[n5] = -1;
        }
        n5 = 1;
        n4 = 0;
        this.results.reduceScore(this.bound.get());
        while (n4 == 0) {
            int n7;
            DnaSequenceTree dnaSequenceTree = this.treeStack[n5 - 1];
            if (n5 == this.N) {
                int n8 = dnaSequenceTree.seq(dnaSequenceTree.root()).score();
                n7 = this.bound.reduce(n8);
                this.results.reduceScore(n7);
                this.results.add(this.signature, n8);
                if (--n5 != n || ++n2 <= n3) continue;
                n4 = 1;
                continue;
            }
            if (this.signature[n5] == 2 * (n5 - 1)) {
                this.signature[n5] = -1;
                if (--n5 != n || ++n2 <= n3) continue;
                n4 = 1;
                continue;
            }
            int n9 = n5;
            this.signature[n9] = this.signature[n9] + 1;
            DnaSequenceTree dnaSequenceTree2 = this.treeStack[n5];
            dnaSequenceTree2.copy(dnaSequenceTree);
            n7 = dnaSequenceTree2.add(this.signature[n5], this.seqList.seq(n5));
            int n10 = FitchParsimony.updateScore(dnaSequenceTree2, n7, this.seqArrayStack[n5]);
            if (n5 > n && n10 + this.absentStates[n5] > this.bound.get()) continue;
            ++n5;
        }
    }
}

