/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.Comm;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeSendByte {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");
    static Comm world;
    static int size;
    static int rank;
    static int reps;
    static int numn;
    static int[] n;

    private TimeSendByte() {
    }

    public static void main(String[] stringArray) throws Exception {
        block9: {
            int n;
            block8: {
                Comm.init(stringArray);
                world = Comm.world();
                size = world.size();
                rank = world.rank();
                if (stringArray.length < 2) {
                    TimeSendByte.usage();
                }
                reps = Integer.parseInt(stringArray[0]);
                numn = stringArray.length - 1;
                TimeSendByte.n = new int[numn];
                for (n = 0; n < numn; ++n) {
                    TimeSendByte.n[n] = Integer.parseInt(stringArray[n + 1]);
                }
                if (rank != 0) break block8;
                System.out.println("java -Dpj.np=2 edu.rit.clu.timing.TimeSendByte " + reps);
                System.out.println(new Date());
                System.out.println("n\ttime1\ttime2\tSend time (sec)");
                for (n = 0; n < numn; ++n) {
                    int n2 = TimeSendByte.n[n];
                    byte[] byArray = new byte[n2];
                    ByteBuf byteBuf = ByteBuf.buffer(byArray);
                    long l = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendByte.fill(n2, byArray, byteBuf);
                    }
                    l += System.currentTimeMillis();
                    long l2 = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendByte.fillSendReceive(n2, byArray, byteBuf);
                    }
                    double d = (double)((l2 += System.currentTimeMillis()) - l) / (double)reps / 2000.0;
                    System.out.print(n2);
                    System.out.print('\t');
                    System.out.print(l);
                    System.out.print('\t');
                    System.out.print(l2);
                    System.out.print('\t');
                    System.out.print(FMT3.format(d));
                    System.out.println();
                }
                break block9;
            }
            if (rank != 1) break block9;
            for (n = 0; n < numn; ++n) {
                int n3;
                int n4 = TimeSendByte.n[n];
                byte[] byArray = new byte[n4];
                ByteBuf byteBuf = ByteBuf.buffer(byArray);
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendByte.fill(n4, byArray, byteBuf);
                }
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendByte.fillReceiveSend(n4, byArray, byteBuf);
                }
            }
        }
    }

    private static void fill(int n, byte[] byArray, ByteBuf byteBuf) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)i;
        }
    }

    private static void fillSendReceive(int n, byte[] byArray, ByteBuf byteBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)i;
        }
        world.send(1, byteBuf);
        world.receive(1, byteBuf);
    }

    private static void fillReceiveSend(int n, byte[] byArray, ByteBuf byteBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)i;
        }
        world.receive(0, byteBuf);
        world.send(0, byteBuf);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=2 edu.rit.clu.timing.TimeSendByte <reps> <n1> [<n2> ...]");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

