## ---- echo = FALSE, message = FALSE---------------------------------------------------------------
library(markdown)
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center")
options(width = 100)
options(rmarkdown.html_vignette.check_title = FALSE)
library(cola)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  ind = sample(ncol(mat), 200)
#  mat1 = mat[, ind]

## ---- eval = FALSE--------------------------------------------------------------------------------
#  rl = run_all_consensus_partition_methods(mat1, ...)
#  cola_report(rl, ...)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  res = consensus_partition(mat, top_value_method = tm, partition_method = pm, ...)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  res = rl[tm, pm]

## ---- eval = FALSE--------------------------------------------------------------------------------
#  mat2 = mat[, setdiff(seq_len(ncol(mat)), ind)]
#  mat2 = t(scale(t(mat2)))
#  cl = predict_classes(res, mat2)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  cl = predict_classes(res, t(scale(t(mat))))

## ---- eval = FALSE--------------------------------------------------------------------------------
#  data(golub_cola)
#  m = get_matrix(golub_cola)
#  
#  set.seed(123)
#  golub_cola_ds = consensus_partition_by_down_sampling(m, subset = 50,
#    anno = get_anno(golub_cola), anno_col = get_anno_col(golub_cola),
#    top_value_method = "SD", partition_method = "kmeans")

## -------------------------------------------------------------------------------------------------
data(golub_cola_ds)
golub_cola_ds

## -------------------------------------------------------------------------------------------------
class = get_classes(golub_cola_ds, k = 2)
nrow(class)
class

## -------------------------------------------------------------------------------------------------
get_classes(golub_cola_ds, p_cutoff = 0.05)

## ---- fig.width = 8, fig.height = 7, out.width = "500"--------------------------------------------
dimension_reduction(golub_cola_ds, k = 2)

## ---- fig.width = 8, fig.height = 7, out.width = "500"--------------------------------------------
get_signatures(golub_cola_ds, k = 2)

## -------------------------------------------------------------------------------------------------
sessionInfo()

